/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute.soap;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.testcase.AbstractAsynchronousTestcase;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.uml.State;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.trace.testcase.uml.UmlObjectFactory;
import ch.e2e.builder.trace.testcase.uml.UmlTree;
import ch.e2e.builder.trace.tree.RefreshAsynchronousTreeEvent;
import ch.e2e.builder.traceviewer.execute.soap.AsynchronousTransaction;
import ch.e2e.builder.traceviewer.execute.soap.GetTraceRequest;
import ch.e2e.event.EventController;
import java.io.File;
import java.util.EventObject;
import java.util.List;
import org.w3c.dom.Document;

public class GetTraceTransaction
extends AsynchronousTransaction {
    public GetTraceTransaction(E2EBuilderModule traceViewer) {
        super(traceViewer);
    }

    public void setTransactionResult(Object result) {
        super.setTransactionResult(result);
        GetTraceRequest request = (GetTraceRequest)result;
        ch.e2e.builder.traceviewer.testcase.AbstractAsynchronousTestcase testcase = request.getSource();
        Document response = request.getResponse();
        if (response != null) {
            testcase.setResponse(response);
            this.handleCompositeStates((AbstractAsynchronousTestcase)testcase);
            EventController.fire((EventObject)new RefreshAsynchronousTreeEvent((Object)this, (TestcaseObject)testcase));
        }
    }

    private void handleCompositeStates(AbstractAsynchronousTestcase testcase) {
        UmlTree umlTree = testcase.getUmlTree();
        if (umlTree != null) {
            List states = umlTree.getStates();
            for (State state : states) {
                File stateDiagramFile = new File(testcase.getTraceFolder(), state.getFilename() + ".xml");
                if (!stateDiagramFile.exists()) continue;
                UmlObject stateDiagram = UmlObjectFactory.createUmlObject((File)stateDiagramFile);
                for (int i = 0; i < stateDiagram.getChildCount(); ++i) {
                    UmlObject child = (UmlObject)stateDiagram.getChild(i);
                    state.addChild(child);
                }
            }
        }
    }
}

