/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.dom.DomUtilities;
import ch.e2e.test.CompareFile;
import ch.e2e.test.E2ETest;
import ch.e2e.test.E2ETestResult;
import ch.e2e.test.XMLCompare;
import ch.e2e.test.options.CompareFileOption;
import ch.e2e.transformer.TransformerLoadException;
import ch.e2e.transformer.TransformerLoader;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.custommonkey.xmlunit.Diff;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbstractXsltTest
extends E2ETest {
    AbstractErrorHandler errorHandler = null;
    private static HashMap<String, Transformer> transformers = new HashMap();
    private XMLCompare xmlCompare;

    private static String getTransformerBasePath() {
        String path = System.getProperty("ch.e2e.builder.compiler.build.AbstractXsltTest.transformerBasePath");
        if (path == null) {
            path = "testcases/compiler";
        }
        return path;
    }

    private String getDestinationSubPath() {
        String path = System.getProperty("ch.e2e.builder.compiler.build.AbstractXsltTest.destinationPath");
        if (path == null) {
            path = "output/compiler";
        }
        return StringTools.replaceProperties((String)path, (Map)this.getRunProperties());
    }

    private String getSourceSubPath() {
        String path = System.getProperty("ch.e2e.builder.compiler.build.AbstractXsltTest.sourcePath");
        if (path == null) {
            path = "sources/compiler";
        }
        return StringTools.replaceProperties((String)path, (Map)this.getRunProperties());
    }

    private String getControlSubPath() {
        String path = System.getProperty("ch.e2e.builder.compiler.build.AbstractXsltTest.controlPath");
        if (path == null) {
            path = "control/compiler";
        }
        return StringTools.replaceProperties((String)path, (Map)this.getRunProperties());
    }

    Transformer getTransformer() throws TransformerLoadException {
        File transformerBasePath = new File(AbstractXsltTest.getTransformerBasePath());
        File transformerPath = new File(transformerBasePath, (String)this.getSource("transformerPath").getValue());
        String transformerScript = (String)this.getSource("transformerScript").getValue();
        return this.getTransformer(transformerPath, transformerScript);
    }

    private Transformer getTransformer(File transformerPath, String transformerScript) throws TransformerLoadException {
        String reloadScript = System.getProperty("ch.e2e.builder.compiler.build.AbstractXsltTest.reloadScript");
        if (reloadScript == null || !Boolean.valueOf(reloadScript).booleanValue()) {
            String transformerId = new File(transformerPath, transformerScript).getAbsolutePath();
            Transformer transformer = transformers.get(transformerId);
            if (transformer == null) {
                TransformerLoader transformerLoader = new TransformerLoader(transformerPath);
                transformer = transformerLoader.getTransformer(transformerScript);
                if (transformer == null) {
                    String message = "Could not load " + transformerId + " transformer.";
                    throw new TransformerLoadException(message);
                }
                if (transformers.size() > 9) {
                    transformers = new HashMap();
                }
                transformers.put(transformerId, transformer);
            }
            return transformer;
        }
        TransformerLoader transformerLoader = new TransformerLoader(transformerPath);
        return transformerLoader.getTransformer(transformerScript);
    }

    File getDestinationAndDelete() {
        File destinationPath = this.getDestinationPath();
        if (!destinationPath.exists()) {
            AbstractXsltTest.assertTrue((String)("Could not create directory " + destinationPath.getAbsolutePath()), (boolean)destinationPath.mkdirs());
        }
        String name = this.getSourceName();
        File destinationFile = new File(destinationPath, name);
        CompareFileOption destination = new CompareFileOption("destination", -1);
        destination.setValue(new CompareFile(destinationFile));
        this.xmlCompare.getOptions().put("xml.compare.test.file", destination);
        if (destinationFile.exists()) {
            AbstractXsltTest.assertTrue((String)("Could not delete " + destinationFile.getAbsolutePath()), (boolean)destinationFile.delete());
        }
        return destinationFile;
    }

    protected E2ETestResult createTestResult(Element testcase) {
        E2ETestResult result = new E2ETestResult("XSLT Test TestResult");
        this.xmlCompare = new XMLCompare();
        result.getResultCompares().add(this.xmlCompare);
        this.setResult(result);
        return result;
    }

    private File getDestinationPath() {
        File destinationPath = new File(this.getDestinationSubPath());
        destinationPath = new File(destinationPath, (String)this.getSource("transformerPath").getValue());
        String transformerScript = (String)this.getSource("transformerScript").getValue();
        destinationPath = new File(destinationPath, transformerScript);
        return destinationPath;
    }

    private String getSourceName() {
        return this.getSource().getName();
    }

    public File getSource() {
        File sourcePath = new File(this.getSourceSubPath());
        return new File(sourcePath, this.getSource("sourceFile").getValue().toString());
    }

    void defineReferenceFileForComparison() {
        File controlPath = this.getControlPath();
        String name = this.getSourceName();
        File control = new File(controlPath, name);
        CompareFileOption reference = new CompareFileOption("referenceFile", -1);
        reference.setValue(new CompareFile(control));
        this.xmlCompare.getOptions().put("xml.compare.reference.file", reference);
    }

    private File getControlPath() {
        String transformerScript = (String)this.getSource("transformerScript").getValue();
        File controlPath = new File(this.getControlSubPath());
        controlPath = new File(controlPath, (String)this.getSource("transformerPath").getValue());
        controlPath = new File(controlPath, transformerScript);
        return controlPath;
    }

    File getWarningControl() {
        return new File(this.getControlPath(), this.getWarningFileName());
    }

    private String getWarningFileName() {
        return StringTools.replace((String)this.getSourceName(), (String)".", (String)"Warning.", (boolean)false);
    }

    File getWarningDestinationAndDelete() {
        File file = new File(this.getDestinationPath(), this.getWarningFileName());
        if (file.exists()) {
            AbstractXsltTest.assertTrue((String)("Could not delete " + file.getAbsolutePath()), (boolean)file.delete());
        }
        return file;
    }

    void assertEqual(File controlFile, File destinationFile) throws IOException, ParserConfigurationException, SAXException {
        AbstractXsltTest.assertTrue((String)("File " + controlFile.getAbsolutePath() + " does not exists."), (boolean)controlFile.exists());
        Document controlDocument = DomUtilities.parse((File)controlFile, (boolean)false, (boolean)false);
        Document destinationDocument = DomUtilities.parse((File)destinationFile, (boolean)false, (boolean)false);
        Diff diff = new Diff(controlDocument, destinationDocument);
        this.assertXMLIdentical("XML not equal for " + controlFile.getAbsolutePath(), diff, true);
    }

    protected void doTearDown() {
        if (this.errorHandler != null) {
            XSLTErrorHandler.getInstance().removeErrorHandler(this.errorHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transform(Transformer transformer, Source source, Result result) throws TransformerException {
        try {
            transformer.transform(source, result);
        }
        finally {
            transformer.reset();
        }
    }

    public String toString() {
        return this.getOwner().getName();
    }
}

