/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.logimport;

import ch.e2e.builder.traceviewer.logimport.LogRequest;
import ch.e2e.builder.traceviewer.logimport.LogResponse;
import ch.e2e.builder.traceviewer.logimport.Logging;
import ch.e2e.log.ASTHost;
import ch.e2e.log.ASTHttpHeader;
import ch.e2e.log.ASTHttpVersion;
import ch.e2e.log.ASTId;
import ch.e2e.log.ASTLog;
import ch.e2e.log.ASTPath;
import ch.e2e.log.ASTSoapAction;
import ch.e2e.log.ASTSoapRequest;
import ch.e2e.log.ASTSoapResponse;
import ch.e2e.log.ASTXml;
import ch.e2e.log.LogParser;
import ch.e2e.log.LogParserVisitor;
import ch.e2e.log.ParseException;
import ch.e2e.log.SimpleNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Log
implements LogParserVisitor {
    private List<LogRequest> requests = new ArrayList<LogRequest>();
    private Map<Integer, LogResponse> responses = new HashMap<Integer, LogResponse>();

    public Log(LogParser parser) throws ParseException {
        this();
        parser.log().jjtAccept((LogParserVisitor)this, null);
    }

    public Log() {
    }

    public List<LogRequest> getRequests() {
        return this.requests;
    }

    public LogResponse getResponse(LogRequest request) {
        return this.getResponse(request.getId());
    }

    public LogResponse getResponse(int id) {
        return this.responses.get(id);
    }

    public Object visit(ASTLog node, Object data) {
        return node.childrenAccept((LogParserVisitor)this, data);
    }

    public Object visit(ASTHost node, Object data) {
        if (data instanceof LogRequest) {
            ((LogRequest)data).setHost(node.getHost());
            ((LogRequest)data).addHttpHeader("Host", node.getHost());
        }
        return data;
    }

    public Object visit(ASTHttpHeader node, Object data) {
        if (data instanceof LogRequest) {
            ((LogRequest)data).addHttpHeader(node.getKey(), node.getValue());
        } else if (data instanceof LogResponse) {
            String value = node.getValue();
            ((LogResponse)data).addHttpHeader(node.getKey() + (value == null ? ":" : ": " + node.getValue()));
        }
        return data;
    }

    public Object visit(ASTHttpVersion node, Object data) {
        if (data instanceof LogRequest) {
            ((LogRequest)data).setHttpVersion(node.getVersion());
        }
        return data;
    }

    public Object visit(ASTId node, Object data) {
        Logging result = null;
        if (data instanceof LogRequest) {
            result = this.visit(node, (LogRequest)data);
        } else if (data instanceof LogResponse) {
            result = this.visit(node, (LogResponse)data);
        }
        return result;
    }

    private LogRequest visit(ASTId node, LogRequest data) {
        data.setId(node.getTestcaseId());
        node.childrenAccept((LogParserVisitor)this, (Object)data);
        return data;
    }

    private LogResponse visit(ASTId node, LogResponse data) {
        data.setId(node.getTestcaseId());
        node.childrenAccept((LogParserVisitor)this, (Object)data);
        return data;
    }

    public Object visit(ASTPath node, Object data) {
        if (data instanceof LogRequest) {
            ((LogRequest)data).setPath(node.getPath().replace('.', '/'));
        }
        return data;
    }

    public Object visit(ASTSoapAction node, Object data) {
        if (data instanceof LogRequest) {
            ((LogRequest)data).setSoapAction(node.getAction());
            ((LogRequest)data).addHttpHeader("SOAPAction", node.getAction());
        }
        return data;
    }

    public Object visit(ASTSoapRequest node, Object data) {
        LogRequest request = new LogRequest();
        node.childrenAccept((LogParserVisitor)this, (Object)request);
        this.requests.add(request);
        return data;
    }

    public Object visit(ASTSoapResponse node, Object data) {
        LogResponse response = new LogResponse();
        node.childrenAccept((LogParserVisitor)this, (Object)response);
        this.responses.put(response.getId(), response);
        return data;
    }

    public Object visit(ASTXml node, Object data) {
        Logging result = null;
        if (data instanceof LogRequest) {
            result = this.visit(node, (LogRequest)data);
        } else if (data instanceof LogResponse) {
            result = this.visit(node, (LogResponse)data);
        }
        return result;
    }

    private LogRequest visit(ASTXml node, LogRequest data) {
        data.setRequest(node.getCode());
        return data;
    }

    private LogResponse visit(ASTXml node, LogResponse data) {
        data.setResponse(node.getCode());
        return data;
    }

    public Object visit(SimpleNode node, Object data) {
        return data;
    }
}

