/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.resource.ImageLoader;
import ch.e2e.resource.MultiMapProperties;
import ch.e2e.resource.Properties;
import ch.e2e.test.EmptyFaultTest;
import ch.e2e.test.EmptyTest;
import ch.e2e.test.TestCreateAction;
import ch.e2e.test.TestType;
import java.io.File;
import java.util.HashMap;
import java.util.MissingResourceException;
import javax.swing.ImageIcon;

public class TypeFactory {
    private static TypeFactory typeFactory;
    private HashMap<String, TestType> types = new HashMap();

    private TypeFactory() {
        this.types.put("EMPTY", new TestType("EMPTY", EmptyTest.class, true, false, null));
        this.types.put("EMPTYFAULT", new TestType("EMPTYFAULT", EmptyFaultTest.class, true, false, null));
        this.types.put("BOOLEAN", new TestType("BOOLEAN", Boolean.class, true, false, null));
        this.types.put("FILE", new TestType("FILE", File.class, true, false, null));
        this.types.put("FLOAT", new TestType("FLOAT", Double.class, true, false, null));
        this.types.put("DOUBLE", new TestType("DOUBLE", Double.class, true, false, null));
        this.types.put("INT", new TestType("INT", Integer.class, true, false, null));
        this.types.put("INTEGER", new TestType("INTEGER", Integer.class, true, false, null));
        this.types.put("BYTE", new TestType("BYTE", Integer.class, true, false, null));
        this.types.put("SHORT", new TestType("SHORT", Integer.class, true, false, null));
        this.types.put("STRING", new TestType("STRING", String.class, true, false, null));
        try {
            MultiMapProperties properties = new MultiMapProperties("ch.e2e.test.testtypes", "test.types");
            this.addTypes((Properties)properties, false, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static TypeFactory getInstance() {
        if (typeFactory == null) {
            typeFactory = new TypeFactory();
        }
        return typeFactory;
    }

    public TestType addType(String name, String type, boolean create, boolean optionsEditable, String iconName) throws ClassNotFoundException {
        TestType clazz = this.types.get(name.toUpperCase());
        ImageIcon icon = ImageLoader.loadIcon((String)iconName, (boolean)false);
        if (clazz == null) {
            clazz = new TestType(name, Class.forName(type), create, optionsEditable, icon);
            this.types.put(name.toUpperCase(), clazz);
        } else if (icon != null && clazz.getIcon() == null) {
            clazz.setIcon(icon);
        }
        return clazz;
    }

    public void addTypes(Properties typeProperties, boolean ignoreCreateFlag, boolean ignoreOptionsFlag) {
        String mapKey = typeProperties instanceof MultiMapProperties ? ((MultiMapProperties)typeProperties).getMapKey() : null;
        for (Object o : typeProperties.keySet()) {
            String name = (String)o;
            if (!this.isValidKey(name, mapKey)) continue;
            TestCreateAction createAction = null;
            String classname = typeProperties.getString(name);
            try {
                TestType type;
                String iconName;
                boolean optionsEditable;
                boolean create;
                if (ignoreCreateFlag) {
                    create = true;
                } else {
                    try {
                        create = typeProperties.getBoolean(name + ".create");
                    }
                    catch (MissingResourceException e) {
                        create = true;
                    }
                }
                if (create) {
                    try {
                        String createActionName = typeProperties.getString(name + ".create.action");
                        Class<?> createActionClass = Class.forName(createActionName);
                        createAction = (TestCreateAction)createActionClass.newInstance();
                    }
                    catch (Exception createActionName) {
                        // empty catch block
                    }
                }
                if (ignoreOptionsFlag) {
                    optionsEditable = true;
                } else {
                    try {
                        optionsEditable = typeProperties.getBoolean(name + ".options");
                    }
                    catch (MissingResourceException e) {
                        optionsEditable = false;
                    }
                }
                try {
                    iconName = typeProperties.getString(name + ".icon");
                }
                catch (MissingResourceException e) {
                    iconName = "no.image";
                }
                if ((type = this.addType(name, classname, create, optionsEditable, iconName)) == null) continue;
                if (typeProperties.containsKey((Object)(name + ".name"))) {
                    type.setDisplayName(typeProperties.getString(name + ".name"));
                }
                type.setCreateAction(createAction);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public HashMap<String, TestType> getTypes(Properties typeProperties) {
        String mapKey = typeProperties instanceof MultiMapProperties ? ((MultiMapProperties)typeProperties).getMapKey() : null;
        HashMap<String, TestType> result = new HashMap<String, TestType>();
        for (Object key : typeProperties.keySet()) {
            String name = key.toString();
            if (!this.isValidKey(name, mapKey)) continue;
            try {
                result.put(name, this.getType(name));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return result;
    }

    public TestType getType(String name) throws ClassNotFoundException {
        TestType test = this.types.get(name.toUpperCase());
        if (test == null) {
            test = new TestType(name, Class.forName(name), true, false, null);
            this.types.put(name.toUpperCase(), test);
        }
        return test;
    }

    public HashMap<String, TestType> getGlobalResultTests() {
        HashMap<String, TestType> result = new HashMap<String, TestType>();
        result.put("XMLCOMPARE", this.types.get("XMLCOMPARE"));
        result.put("FILECOMPARE", this.types.get("FILECOMPARE"));
        result.put("DIRECTORYCOMPARE", this.types.get("DIRECTORYCOMPARE"));
        return result;
    }

    private boolean isValidKey(String key, String mapKey) {
        key = key.toUpperCase();
        boolean isMapKey = mapKey != null && mapKey.toUpperCase().equals(key);
        return !key.endsWith(".CREATE") && !key.endsWith(".CREATE.ACTION") && !key.endsWith(".ICON") && !key.endsWith(".OPTIONS") && !key.endsWith(".NAME") && !isMapKey;
    }
}

