/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import java.util.ArrayList;
import java.util.Collection;
import org.custommonkey.xmlunit.ComparisonController;
import org.custommonkey.xmlunit.DifferenceEngine;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.ElementQualifier;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class E2EDifferenceEngine
extends DifferenceEngine {
    private Collection<String> ignoreAttributes;
    private Collection<String> ignoreElements;
    private String ignoredElement;

    public E2EDifferenceEngine(ComparisonController comparisonController, Collection<String> ignoreAttributes, Collection<String> ignoreElements) {
        super(comparisonController);
        this.ignoreAttributes = ignoreAttributes == null ? new ArrayList() : ignoreAttributes;
        this.ignoreElements = ignoreElements == null ? new ArrayList() : ignoreElements;
    }

    protected void compareElement(Element element, Element element1, DifferenceListener differenceListener) throws DifferenceEngine.DifferenceFoundException {
        if (this.ignoreElements.contains(element.getNodeName()) && element.getNodeName().equals(element1.getNodeName())) {
            this.ignoredElement = element.getNodeName();
        } else if (this.isNotIgnored(element)) {
            this.ignoredElement = null;
            super.compareElement(element, element1, differenceListener);
        }
    }

    protected void compareText(Text control, Text test, DifferenceListener listener) throws DifferenceEngine.DifferenceFoundException {
        if (!control.getData().equals("${_IGNORE_}")) {
            super.compareText(control, test, listener);
        }
    }

    private boolean isNotIgnored(Node element) {
        boolean notIgnored = true;
        if (this.ignoredElement != null) {
            for (Node parent = element; parent != null && notIgnored; parent = parent.getParentNode()) {
                notIgnored = !parent.getNodeName().equals(this.ignoredElement);
            }
        }
        return notIgnored;
    }

    protected void compareAttribute(Attr attr1, Attr attr2, DifferenceListener differenceListener) throws DifferenceEngine.DifferenceFoundException {
        if (!attr1.getName().equals(attr2.getName()) || !this.ignoreAttributes.contains(attr1.getName())) {
            super.compareAttribute(attr1, attr2, differenceListener);
        }
    }

    protected void compareNodeChildren(Node control, Node test, DifferenceListener listener, ElementQualifier elementQualifier) throws DifferenceEngine.DifferenceFoundException {
        if (this.isNotIgnored(control)) {
            super.compareNodeChildren(control, test, listener, elementQualifier);
        }
    }
}

