/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.io;

import ch.e2e.io.FilesNotDeletedException;
import ch.e2e.io.Logging;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;

public final class FileUtilities
implements Logging {
    private static final int BUFF_SIZE = 100000;
    private static DirFilter dirFilter = new DirFilter();
    private static FileFilter allFilesFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile();
        }
    };

    private FileUtilities() {
    }

    public static String getFilename(File file, char charToInsert, boolean flatten) {
        return FileUtilities.getFilename(FileUtilities.getAbsolutePath(file, true), charToInsert, flatten);
    }

    public static String getFilename(String filename, char charToInsert, boolean flatten) {
        String replaceChars = "|:*?<>\\\"'`\u00b4^";
        if (flatten) {
            replaceChars = replaceChars + "/\\";
        }
        filename = charToInsert == '\u0000' ? StringTools.removeChars(filename, replaceChars) : StringTools.replaceChars(filename, replaceChars, charToInsert);
        return filename.trim();
    }

    public static boolean isInPath(File file, File path) {
        boolean result = false;
        File parent = file;
        while (parent != null && !result) {
            if (parent.equals(path)) {
                result = true;
                continue;
            }
            parent = parent.getParentFile();
        }
        return result;
    }

    public static String getRelativePath(File file, File baseFolder) {
        try {
            file = file.getCanonicalFile();
            baseFolder = baseFolder.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        String relativePath = null;
        if (baseFolder.isFile()) {
            throw new IllegalArgumentException("baseFolder must be a directory");
        }
        if (file.equals(baseFolder)) {
            return "";
        }
        if (file.isAbsolute()) {
            File[] basePath;
            File[] filePath = FileUtilities.getPathToRoot(file);
            int parentIndex = FileUtilities.getParentIndex(filePath, basePath = FileUtilities.getPathToRoot(baseFolder));
            if (parentIndex != -1) {
                int i;
                int length = basePath.length - (parentIndex + 1);
                StringBuilder path = new StringBuilder();
                for (i = 0; i < length; ++i) {
                    path.append("../");
                }
                for (i = parentIndex + 1; i < filePath.length; ++i) {
                    path.append(filePath[i].getName()).append("/");
                }
                if (file.isFile() && path.length() > 0) {
                    path.setLength(path.length() - 1);
                }
                relativePath = path.toString();
            }
        } else {
            relativePath = !baseFolder.isAbsolute() && file.getPath().startsWith(baseFolder.getPath()) && file.getPath().length() > baseFolder.getPath().length() ? (baseFolder.getPath().length() == 0 ? file.getPath().substring(baseFolder.getPath().length()) : file.getPath().substring(baseFolder.getPath().length() + 1)) : file.getPath();
        }
        if (relativePath == null) {
            relativePath = FileUtilities.getAbsolutePath(file);
        }
        if ((relativePath = relativePath.replace('\\', '/')).endsWith("/")) {
            relativePath = relativePath.substring(0, relativePath.length() - 1);
        }
        return relativePath;
    }

    private static int getParentIndex(File[] path1, File[] path2) {
        if (path1[0].equals(path2[0])) {
            int i;
            int length = Math.min(path1.length, path2.length);
            for (i = 1; i < length; ++i) {
                if (path1[i].equals(path2[i])) continue;
                return i - 1;
            }
            return i - 1;
        }
        return -1;
    }

    public static String[] getAllDirectoryNames(String dir) {
        return FileUtilities.getAllDirectoryNames(new File(dir));
    }

    public static String[] getAllDirectoryNames(File dir) {
        return dir.list(dirFilter);
    }

    public static File[] getAllDirectories(String dir) {
        return FileUtilities.getAllDirectories(new File(dir));
    }

    public static File[] getAllDirectories(File dir) {
        File[] files = dir.listFiles(dirFilter);
        ArrayList<File> fileList = new ArrayList<File>();
        if (files != null) {
            for (File file : files) {
                if (!file.canRead()) continue;
                fileList.add(file);
            }
        }
        files = new File[fileList.size()];
        fileList.toArray(files);
        return files;
    }

    public static File[] getAllDirectories(File dir, String[] excludedNames) {
        ArrayList<String> excludes = new ArrayList<String>(Arrays.asList(excludedNames));
        File[] files = dir.listFiles(dirFilter);
        ArrayList<File> fileList = new ArrayList<File>();
        if (files != null) {
            for (File file : files) {
                if (!file.canRead() || excludes.contains(file.getName())) continue;
                fileList.add(file);
            }
        }
        files = new File[fileList.size()];
        fileList.toArray(files);
        return files;
    }

    public static String[] getFilenameList(String dir, FilenameFilter fileFilter) {
        return FileUtilities.getFilenameList(new File(dir), fileFilter, false);
    }

    public static String[] getFilenameList(String dir, FilenameFilter fileFilter, boolean recursive) {
        return FileUtilities.getFilenameList(new File(dir), fileFilter, recursive);
    }

    public static String[] getFilenameList(File dir, FilenameFilter fileFilter) {
        return FileUtilities.getFilenameList(dir, fileFilter, false);
    }

    public static String[] getFilenameList(File dir, FilenameFilter fileFilter, boolean recursive) {
        String[] files;
        if (recursive) {
            ArrayList<String> filenames = new ArrayList<String>();
            filenames.addAll(Arrays.asList(dir.list(fileFilter)));
            File[] dirs = FileUtilities.getAllDirectories(dir);
            if (dirs != null && dirs.length > 0) {
                for (File dir1 : dirs) {
                    filenames.addAll(Arrays.asList(FileUtilities.getFilenameList(dir1, fileFilter, true)));
                }
            }
            files = new String[filenames.size()];
            filenames.toArray(files);
        } else {
            files = dir.list(fileFilter);
        }
        if (files == null) {
            files = new String[]{};
        }
        return files;
    }

    public static File[] getFileList(String dir, FileFilter fileFilter) {
        return FileUtilities.getFileList(new File(dir), fileFilter, false);
    }

    public static File[] getFileList(String dir, FileFilter fileFilter, boolean recursive) {
        return FileUtilities.getFileList(new File(dir), fileFilter, recursive);
    }

    public static File[] getFileList(File dir, FileFilter fileFilter) {
        return FileUtilities.getFileList(dir, fileFilter, false);
    }

    public static File[] getFileList(String dir, FileFilter[] fileFilter) {
        return FileUtilities.getFileList(new File(dir), fileFilter, false);
    }

    public static File[] getFileList(String dir, FileFilter[] fileFilter, boolean recursive) {
        return FileUtilities.getFileList(new File(dir), fileFilter, recursive);
    }

    public static File[] getFileList(File dir, FileFilter[] fileFilter) {
        return FileUtilities.getFileList(dir, fileFilter, false);
    }

    public static File[] getFileList(File dir, FileFilter[] fileFilter, boolean recursive) {
        ArrayList<File> foundedFiles = new ArrayList<File>();
        for (FileFilter aFileFilter : fileFilter) {
            File[] files;
            for (File file : files = FileUtilities.getFileList(dir, aFileFilter, recursive)) {
                if (foundedFiles.contains(file)) continue;
                foundedFiles.add(file);
            }
        }
        File[] files = new File[foundedFiles.size()];
        foundedFiles.toArray(files);
        return files;
    }

    public static File[] getFileList(File dir, FileFilter fileFilter, boolean recursive) {
        if (recursive) {
            File[] dirs;
            ArrayList<File> foundedFiles = new ArrayList<File>();
            File[] fileList = dir.listFiles(fileFilter);
            if (fileList != null && fileList.length > 0) {
                foundedFiles.addAll(Arrays.asList(fileList));
            }
            if ((dirs = FileUtilities.getAllDirectories(dir)) != null && dirs.length > 0) {
                for (File dir1 : dirs) {
                    foundedFiles.addAll(Arrays.asList(FileUtilities.getFileList(dir1, fileFilter, true)));
                }
            }
            File[] files = new File[foundedFiles.size()];
            foundedFiles.toArray(files);
            return files;
        }
        File[] files = dir.listFiles(fileFilter);
        if (files == null) {
            files = new File[]{};
        }
        return files;
    }

    public static File[] getAllFiles(File dir, boolean recursive) {
        return FileUtilities.getFileList(dir, allFilesFilter, recursive);
    }

    public static File[] getAllFilesAndDirectories(File dir, boolean recursive) {
        return FileUtilities.getFileList(dir, new FileFilter[]{allFilesFilter, dirFilter}, recursive);
    }

    public static void deleteAllFiles(File dir) throws IOException {
        File[] filesToDelete = dir.listFiles();
        if (filesToDelete != null) {
            for (File file : filesToDelete) {
                FileUtilities.deleteFile(file);
            }
        }
    }

    public static void deleteFile(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete file " + file.getAbsolutePath());
        }
    }

    public static void deleteAll(File dir) throws FilesNotDeletedException {
        File[] filesToDelete = dir.listFiles();
        if (filesToDelete != null) {
            ArrayList<File> undeletedFiles = new ArrayList<File>();
            for (File file : filesToDelete) {
                try {
                    if (file.isDirectory() && !Files.isSymbolicLink(file.toPath())) {
                        FileUtilities.deleteDirectory(file);
                        continue;
                    }
                    FileUtilities.deleteFile(file);
                }
                catch (IOException e) {
                    undeletedFiles.add(file);
                }
            }
            if (!undeletedFiles.isEmpty()) {
                throw new FilesNotDeletedException(undeletedFiles);
            }
        }
    }

    public static void silentDeleteAll(File dir) {
        File[] filesToDelete = dir.listFiles();
        if (filesToDelete != null) {
            for (File file : filesToDelete) {
                if (file.isDirectory()) {
                    FileUtilities.silentDeleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
    }

    public static void deleteDirectory(File dir) throws FilesNotDeletedException {
        ArrayList<? extends File> undeletedFiles = new ArrayList<File>();
        if (dir.exists()) {
            try {
                FileUtilities.deleteAll(dir);
            }
            catch (FilesNotDeletedException e) {
                undeletedFiles.addAll(e.getFiles());
            }
            if (!dir.delete()) {
                undeletedFiles.add(dir);
            }
        }
        if (!undeletedFiles.isEmpty()) {
            throw new FilesNotDeletedException(undeletedFiles);
        }
    }

    public static void silentDeleteDirectory(File dir) {
        FileUtilities.silentDeleteAll(dir);
        dir.delete();
    }

    public static void deleteDirectory(String absoluteDirPath) throws IOException {
        FileUtilities.deleteDirectory(new File(absoluteDirPath));
    }

    public static void delete(File dir, FileFilter fileFilter, boolean recursive) {
        File[] filesToDelete;
        for (File file : filesToDelete = FileUtilities.getFileList(dir, fileFilter, recursive)) {
            file.delete();
        }
    }

    public static void copyFile(File from, File to, boolean preserveLastModified) throws IOException {
        if (!from.equals(to)) {
            if (!to.getParentFile().exists()) {
                to.getParentFile().mkdirs();
            }
            FileInputStream in = new FileInputStream(from);
            FileOutputStream out = new FileOutputStream(to);
            FileUtilities.copy(in, out);
        }
        if (preserveLastModified) {
            to.setLastModified(from.lastModified());
        }
    }

    public static void copyFile(File from, File to) throws IOException {
        FileUtilities.copyFile(from, to, false);
    }

    public static void copy(InputStream from, OutputStream to) throws IOException {
        FileUtilities.copy(from, to, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void copy(InputStream from, OutputStream to, boolean closeOutput) throws IOException {
        byte[] buffer = new byte[100000];
        try {
            while (true) {
                byte[] byArray = buffer;
                // MONITORENTER : buffer
                int amountRead = from.read(buffer);
                if (amountRead == -1) {
                    // MONITOREXIT : byArray
                    return;
                }
                to.write(buffer, 0, amountRead);
                // MONITOREXIT : byArray
            }
        }
        finally {
            try {
                from.close();
            }
            catch (Exception exception) {}
            if (closeOutput) {
                try {
                    to.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void copy(InputStream from, OutputStream to, long maxLength) throws IOException {
        int amountRead;
        long count = 0L;
        byte[] buffer = new byte[100000];
        while ((amountRead = from.read(buffer)) != -1) {
            to.write(buffer, 0, amountRead);
            if ((count += (long)amountRead) < maxLength) continue;
            break;
        }
    }

    public static void copyFromClasspath(String filename, OutputStream to) throws IOException {
        InputStream from = FileUtilities.class.getClassLoader().getResourceAsStream(filename);
        FileUtilities.copy(from, to);
    }

    public static void copyFromClasspath(String filename, Writer to) throws IOException {
        InputStream from = FileUtilities.class.getClassLoader().getResourceAsStream(filename);
        FileUtilities.copy(new InputStreamReader(from), to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void copy(Reader from, Writer to) throws IOException {
        char[] buffer = new char[100000];
        try {
            while (true) {
                char[] cArray = buffer;
                // MONITORENTER : buffer
                int amountRead = from.read(buffer);
                if (amountRead == -1) {
                    // MONITOREXIT : cArray
                    return;
                }
                to.write(buffer, 0, amountRead);
                // MONITOREXIT : cArray
            }
        }
        finally {
            try {
                from.close();
            }
            catch (Exception exception) {}
            try {
                to.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void copyDirectory(File source, File target) throws FileNotFoundException, IOException {
        FileUtilities.copyDirectory(source, target, false);
    }

    public static void copyDirectory(File source, File target, boolean overwrite) throws FileNotFoundException, IOException {
        if (source.exists()) {
            File[] files;
            if (!target.exists()) {
                if (!target.mkdir()) {
                    throw new IOException("Could not create directory '" + target.getAbsolutePath() + "'!");
                }
            } else if (!overwrite) {
                throw new IOException("Directory '" + target.getAbsolutePath() + "' allready exists!");
            }
            if ((files = source.listFiles()) != null) {
                for (File file : files) {
                    if (file.isFile()) {
                        FileUtilities.copyFile(file, new File(target, file.getName()));
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    FileUtilities.copyDirectory(file, new File(target, file.getName()));
                }
            }
        }
    }

    public static String getAbsolutePath(String file) {
        return FileUtilities.getAbsolutePath(new File(file), false);
    }

    public static String getAbsolutePath(String file, boolean ignoreDriveInfo) {
        return FileUtilities.getAbsolutePath(new File(file), ignoreDriveInfo);
    }

    public static String getAbsolutePath(File file) {
        return FileUtilities.getAbsolutePath(file, false);
    }

    public static String getAbsolutePath(File file, boolean ignoreDriveInfo) {
        String absolutePath;
        try {
            absolutePath = file.getAbsoluteFile().getCanonicalPath();
            if (absolutePath.length() == file.getAbsolutePath().length() && !absolutePath.equalsIgnoreCase(file.getAbsolutePath())) {
                absolutePath = file.getAbsolutePath();
            }
        }
        catch (IOException ioEx) {
            absolutePath = file.getAbsolutePath();
        }
        return ignoreDriveInfo && absolutePath.charAt(1) == ':' ? absolutePath.substring(2) : absolutePath;
    }

    public static String getAbsoluteFileURL(String file) {
        return FileUtilities.getAbsoluteFileURL(new File(file), false);
    }

    public static String getAbsoluteFileURL(String file, boolean ignoreDriveInfo) {
        return FileUtilities.getAbsoluteFileURL(new File(file), ignoreDriveInfo);
    }

    public static String getAbsoluteFileURL(File file) {
        return FileUtilities.getAbsoluteFileURL(file, false);
    }

    public static String getAbsoluteFileURL(File file, boolean ignoreDriveInfo) {
        try {
            return FileUtilities.getAbsoluteFileURL(file, ignoreDriveInfo, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            return file.getAbsolutePath();
        }
    }

    public static String getAbsoluteFileURL(File file, boolean ignoreDriveInfo, String encoding) throws UnsupportedEncodingException {
        String absolutePath = FileUtilities.getAbsolutePath(file).replace('\\', '/');
        if (ignoreDriveInfo && absolutePath.charAt(1) == ':') {
            absolutePath = absolutePath.substring(2);
        }
        String protocol = absolutePath.startsWith("/") ? "file://" : "file:///";
        String result = URLEncoder.encode(absolutePath, encoding);
        result = StringTools.replaceAll(result, URLEncoder.encode("/", encoding), "/", false);
        result = StringTools.replaceAll(result, URLEncoder.encode(":", encoding), ":", false);
        try {
            URL url = new URL("file", "", result);
            result = url.toString();
            result = protocol + result.substring(5);
        }
        catch (MalformedURLException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(FileUtilities.class.getName(), "getAbsoluteFileURL", e);
        }
        return result;
    }

    public static boolean isEmpty(File directory) {
        boolean result = false;
        if (directory.isDirectory()) {
            result = directory.listFiles().length == 0;
        }
        return result;
    }

    public static boolean containsFiles(File directory) {
        boolean result = false;
        if (directory != null && directory.isDirectory()) {
            result = FileUtilities.getAllFiles(directory, true).length > 0;
        }
        return result;
    }

    public static File[] getPathToRoot(String file) {
        return FileUtilities.getPathToRoot(new File(file));
    }

    public static File[] getPathToRoot(File file) {
        ArrayList<File> files = new ArrayList<File>();
        for (File parent = file; parent != null; parent = parent.getParentFile()) {
            files.add(parent);
        }
        File[] pathToRoot = new File[files.size()];
        int j = pathToRoot.length - 1;
        int i = 0;
        while (i < pathToRoot.length) {
            pathToRoot[i] = (File)files.get(j);
            ++i;
            --j;
        }
        return pathToRoot;
    }

    public static File getRoot(String file) {
        return FileUtilities.getRoot(new File(file));
    }

    public static File getRoot(File file) {
        File root = null;
        File parent = file;
        while ((parent = parent.getParentFile()) != null) {
            root = parent;
        }
        return root;
    }

    public static boolean isRoot(String file) {
        return FileUtilities.isRoot(new File(file));
    }

    public static boolean isRoot(File file) {
        return file.getParent() == null;
    }

    public static File getFile(URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(url.getFile());
        }
    }

    private static class DirFilter
    implements FileFilter,
    FilenameFilter {
        private DirFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }

        @Override
        public boolean accept(File dir, String name) {
            return new File(dir, name).isDirectory();
        }
    }
}

