/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.jdp;

import ch.e2e.builder.jdp.ast.MethodDeclaration;
import ch.e2e.builder.jdp.ast.Parameter;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.util.ReaderInputStream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class JavaDocParser {
    private static final char NBSP = '\u00a0';

    public static List<MethodDeclaration> parse(Reader reader) throws Exception {
        Document document = Jsoup.parse((InputStream)new ReaderInputStream(reader), (String)"UTF-8", (String)"");
        Elements methodSummary = document.select("table:matches(Method Summary|Methods)");
        return JavaDocParser.isJavaDoc9(methodSummary) ? JavaDocParser.parseJavaDoc9(methodSummary) : JavaDocParser.parseJavaDoc(methodSummary);
    }

    private static List<MethodDeclaration> parseJavaDoc9(Elements methodSummary) {
        ArrayList<MethodDeclaration> methodDeclarations = new ArrayList<MethodDeclaration>();
        for (Element method : methodSummary.select("tr[id]")) {
            String name = ((Element)method.select("th.colSecond a[href]:eq(0)").get(0)).text();
            String signature = ((Element)method.select("th.colSecond").get(0)).text();
            String description = JavaDocParser.trimDescription(((Element)method.select("td.colLast").get(0)).text());
            methodDeclarations.add(JavaDocParser.newMethodDeclaration(name, signature, description));
        }
        return methodDeclarations;
    }

    private static List<MethodDeclaration> parseJavaDoc(Elements methodSummary) {
        ArrayList<MethodDeclaration> methodDeclarations = new ArrayList<MethodDeclaration>();
        for (Element method : methodSummary.select("td:eq(1)")) {
            String name = ((Element)method.select("a[href]:eq(0)").get(0)).text();
            String methodSignatureAndDescription = method.text();
            int idx = methodSignatureAndDescription.indexOf(41);
            String signature = methodSignatureAndDescription.substring(0, idx + 1);
            String description = JavaDocParser.trimDescription(methodSignatureAndDescription.substring(idx + 1));
            methodDeclarations.add(JavaDocParser.newMethodDeclaration(name, signature, description));
        }
        return methodDeclarations;
    }

    private static boolean isJavaDoc9(Elements methodSummary) {
        return methodSummary.select("th:eq(2)").size() == 1;
    }

    private static String trimDescription(String description) {
        int j = -1;
        for (int i = 0; j == -1 && i < description.length(); ++i) {
            if (!Character.isLetterOrDigit(description.charAt(i))) continue;
            j = i;
        }
        return j == -1 ? "" : description.substring(j);
    }

    private static MethodDeclaration newMethodDeclaration(String name, String signature, String description) {
        return new MethodDeclaration(name, description, JavaDocParser.getParameters(signature));
    }

    private static List<Parameter> getParameters(String signature) {
        signature = signature.replaceAll("<.*?>(?=\\xa0)", "");
        List<String> parameterNames = JavaDocParser.parseParameterNames(signature);
        List<String> parameterTypes = JavaDocParser.parseParameterTypes(signature);
        int n = parameterNames.size();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(n);
        for (int i = 0; i < n; ++i) {
            parameters.add(new Parameter(parameterTypes.get(i), parameterNames.get(i)));
        }
        return parameters;
    }

    private static List<String> parseParameterNames(String str) {
        int preIndex = str.indexOf(160);
        if (preIndex == -1) {
            return Collections.emptyList();
        }
        ArrayList<String> parametersNames = new ArrayList<String>();
        String tailStr = str.substring(preIndex + 1);
        boolean done = false;
        while (!done) {
            int index = 0;
            char ch = tailStr.charAt(index);
            while (ch != ',' && ch != ')') {
                ch = tailStr.charAt(++index);
            }
            parametersNames.add(tailStr.substring(0, index));
            if (ch == ')') {
                done = true;
                continue;
            }
            tailStr = tailStr.substring(index + 1);
            preIndex = tailStr.indexOf(160);
            tailStr = tailStr.substring(preIndex + 1);
        }
        return parametersNames;
    }

    private static List<String> parseParameterTypes(String str) {
        String[] strArray = (str = str.replace('\u00a0', ' ')).split("\\s+");
        if (strArray.length < 2) {
            return Collections.emptyList();
        }
        ArrayList<String> parameterTypes = new ArrayList<String>();
        for (int i = 0; i < strArray.length; i += 2) {
            int index = 0;
            char ch = strArray[i].charAt(index);
            if (i == 0 && strArray[i].contains("(")) {
                while (ch != '(') {
                    ch = strArray[i].charAt(++index);
                }
                ++index;
            }
            String subStr = strArray[i].substring(index);
            int subIndex = 0;
            if (subStr.contains(".")) {
                for (int j = 0; j < subStr.length(); ++j) {
                    if (subStr.charAt(j) != '.') continue;
                    subIndex = j;
                }
                if (subIndex != 0) {
                    ++subIndex;
                }
            }
            parameterTypes.add(subStr.substring(subIndex));
        }
        return parameterTypes;
    }
}

