/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase;

import ch.e2e.builder.trace.testcase.AddWatchResult;
import ch.e2e.builder.trace.testcase.FlowNotInspectedException;
import ch.e2e.builder.trace.testcase.LogFile;
import ch.e2e.builder.trace.testcase.RequestLogFile;
import ch.e2e.builder.trace.testcase.ResponseLogFile;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.builder.trace.testcase.TestcaseWatch;
import ch.e2e.builder.trace.testcase.TraceSettings;
import ch.e2e.builder.trace.testcase.WatchList;
import ch.e2e.builder.trace.testcase.request.Request;
import ch.e2e.builder.trace.testcase.uml.InspectionObject;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.trace.testcase.uml.UmlTree;
import ch.e2e.builder.trace.tools.ActionScriptHelper;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.FilesNotDeletedException;
import ch.e2e.transformer.TransformerLoadException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class Testcase
extends TestcaseContainer {
    protected static final String ENCODING = "UTF-8";
    protected File home;
    private UmlTree umlTree;
    protected TraceSettings traceSettings;
    protected String description;
    protected int status;
    protected long lastRunDate;
    protected LogFile requestLog;
    protected LogFile responseLog;
    protected WatchList watches = new WatchList();
    protected ArrayList<Object> responseWatches;
    private int timeout = 180;
    private File traceFolder;

    public Testcase(String name, File home, int type) {
        super(name, type);
        this.home = home;
        this.requestLog = new RequestLogFile(this);
        this.responseLog = new ResponseLogFile(this);
        this.clearGraphFolder();
    }

    public long getRunDate() {
        return this.lastRunDate;
    }

    @Override
    public Object getChild(int index) {
        LogFile result;
        int offset = 0;
        if (this.requestLog.exists()) {
            ++offset;
        }
        if (this.responseLog.exists()) {
            ++offset;
        }
        switch (index) {
            case 0: {
                if (this.requestLog.exists()) {
                    result = this.requestLog;
                    break;
                }
                if (this.responseLog.exists()) {
                    result = this.responseLog;
                    break;
                }
                result = this.umlTree == null ? null : this.umlTree.getChild(0);
                break;
            }
            case 1: {
                if (this.requestLog.exists() && this.responseLog.exists()) {
                    result = this.responseLog;
                    break;
                }
                result = this.umlTree == null ? null : this.umlTree.getChild(index - offset);
                break;
            }
            default: {
                result = this.umlTree == null ? null : this.umlTree.getChild(index - offset);
            }
        }
        return result;
    }

    @Override
    public int getChildCount() {
        int count = 0;
        if (this.requestLog.exists()) {
            ++count;
        }
        if (this.responseLog.exists()) {
            ++count;
        }
        if (this.umlTree != null) {
            count += this.umlTree.getChildCount();
        }
        return count;
    }

    @Override
    public int getIndexOfChild(Object child) {
        return 0;
    }

    @Override
    public abstract boolean isLeaf();

    public abstract void saveRequest();

    public abstract Request getRequest() throws IOException, SAXException, ParserConfigurationException;

    public abstract String getRequestData() throws IOException;

    public abstract long requestLastModified();

    public abstract long responseLastModified();

    public abstract String getResponseData();

    protected abstract void createDefaultProperties();

    public abstract boolean isRPCEncoding();

    public abstract String getLocation();

    public ZipFile getRepository() {
        return null;
    }

    public File getHome() {
        return this.home;
    }

    public void setHome(File newHome) {
        this.home = newHome;
        this.requestLog = new RequestLogFile(this);
        this.responseLog = new ResponseLogFile(this);
    }

    public String getWsdlFolderPath() {
        return null;
    }

    public UmlTree getUmlTree() {
        return this.umlTree;
    }

    public void setUmlTree(UmlTree umlTree) {
        this.umlTree = umlTree;
        if (umlTree != null) {
            umlTree.setOwner(this);
        }
    }

    public TraceSettings getTraceSettings() {
        return this.traceSettings;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setLastRunInfos() {
        this.traceSettings.setLastRunInfos();
    }

    @Override
    public void setName(String name) {
        this.traceFolder = null;
        super.setName(name);
    }

    public File getTraceFolder() {
        if (this.traceFolder == null) {
            File oldTraceFolder;
            this.traceFolder = new File(this.home, ".$" + this.getName() + ".trace");
            if (!this.traceFolder.exists() && (oldTraceFolder = new File(this.home, this.getName() + ".trace")).exists() && !oldTraceFolder.renameTo(this.traceFolder)) {
                System.out.println("Could not rename " + oldTraceFolder + " to " + this.traceFolder);
            }
        }
        return this.traceFolder;
    }

    public void setTraceFolder(File traceFolder) {
        this.traceFolder = traceFolder;
        this.requestLog.renameTo(traceFolder);
        this.responseLog.renameTo(traceFolder);
    }

    public File getGraphFolder() {
        return new File(this.home, ".$" + this.getName() + ".graph");
    }

    public File getResponseFile() {
        return new File(this.getTraceFolder(), "response");
    }

    public File getIOFile() {
        return new File(this.getTraceFolder(), ".io");
    }

    @Override
    public int getType() {
        return this.getStatus();
    }

    public String getResponseLogData() {
        String result = null;
        try {
            StringWriter out = new StringWriter();
            FileUtilities.copy((Reader)new FileReader(this.responseLog.getLogFile()), (Writer)out);
            result = out.toString();
        }
        catch (IOException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "getResponseLogData", e);
        }
        return result;
    }

    public LogFile getRequestLog() {
        return this.requestLog;
    }

    public LogFile getResponseLog() {
        return this.responseLog;
    }

    protected Reader read(File file) throws FileNotFoundException, UnsupportedEncodingException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), ENCODING));
    }

    protected Writer write(File file) throws FileNotFoundException, UnsupportedEncodingException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING));
    }

    public ArrayList getResponseWatches() {
        if (this.responseWatches == null) {
            block8: {
                this.responseWatches = new ArrayList();
                File responseFile = this.getResponseFile();
                if (responseFile.exists()) {
                    try {
                        Document responseDocument = DomUtilities.parse((File)responseFile, (boolean)false, (boolean)false);
                        String uri = this.getRequest().getNamespacesManager().getSoapEnvelopeNamespaceUri();
                        NodeList responses = responseDocument.getElementsByTagNameNS(uri, "Body");
                        if (responses == null || responses.getLength() != 1) break block8;
                        Element body = (Element)responses.item(0);
                        NodeList childNodes = body.getChildNodes();
                        Element responseElement = null;
                        int length = childNodes.getLength();
                        for (int i = 0; i < length && responseElement == null; ++i) {
                            Node child = childNodes.item(i);
                            if (!(child instanceof Element)) continue;
                            responseElement = (Element)child;
                        }
                        if (responseElement != null) {
                            this.appendResponseWatches(responseElement, this.responseWatches);
                        }
                    }
                    catch (Exception e) {
                        logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                        logger.throwing(this.getClass().getName(), "getResponseWatches", e);
                    }
                } else {
                    this.responseWatches.add("testcase.no.response.exists");
                }
            }
            if (this.responseWatches.size() == 0) {
                this.responseWatches.add("testcase.no.response.values.found");
            }
        }
        return this.responseWatches;
    }

    protected void appendResponseWatches(Element responseElement, ArrayList<Object> responseWatches) {
        NodeList children = responseElement.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element) || !child.hasChildNodes()) continue;
            String id = child.getFirstChild().getNodeValue().trim();
            responseWatches.add(new TestcaseWatch(id, this.getIOFile(), null));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AddWatchResult addWatch(URL url, String diagramName) throws FlowNotInspectedException {
        String query = url.getQuery();
        String[] parameterList = query.split("&");
        String[] parameter = parameterList[0].split("\\?");
        String[] firstParameter = parameter[0].split("=");
        AddWatchResult result = null;
        if (firstParameter.length > 1) {
            String id = firstParameter[1];
            TestcaseWatch watch = (TestcaseWatch)this.watches.get(id);
            if (watch != null) return new AddWatchResult(watch, false);
            watch = new TestcaseWatch(id, this.getIOFile(), diagramName);
            if (watch.isEmpty() && parameter.length > 1) {
                String flow = parameter[1].split("=")[1];
                if (!this.traceSettings.containsInspectedElement(flow)) throw new FlowNotInspectedException(flow);
                this.watches.addParameter(id, watch);
                return new AddWatchResult(watch, true);
            } else {
                this.watches.addParameter(id, watch);
            }
            return new AddWatchResult(watch, true);
        }
        logger.info("Couldn't find watch for URL '" + url + "' in diagram '" + url + "'.");
        return result;
    }

    public void removeAllWatches() {
        this.watches.clear();
    }

    public void removeWatch(TestcaseWatch watch) {
        this.watches.remove(watch);
    }

    public TestcaseParameter getWatch(int index) {
        return this.watches.get(index);
    }

    public int indexOfWatch(TestcaseWatch watch) {
        return this.watches.indexOf(watch);
    }

    public int getWatchesCount() {
        return this.watches.size();
    }

    @Override
    public void delete() throws FilesNotDeletedException {
        File[] filesToDelete;
        ArrayList<File> undeletedFiles = new ArrayList<File>();
        for (File file : filesToDelete = FileUtilities.getFileList((File)this.home, (FileFilter)new TestcaseFilesFileFilter())) {
            if (file.delete()) continue;
            undeletedFiles.add(file);
            logger.info("Couldn't delete file '" + file.getPath() + "'");
        }
        try {
            this.clearResultObjects();
        }
        catch (FilesNotDeletedException e) {
            undeletedFiles.addAll(e.getFiles());
        }
        this.clear();
        if (!undeletedFiles.isEmpty()) {
            throw new FilesNotDeletedException(undeletedFiles);
        }
    }

    @Override
    public void clear() {
        this.removeInspectionListeners();
        this.umlTree = null;
    }

    @Override
    public int hashCode() {
        return this.getTestcaseFile().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Testcase && this.getTestcaseFile().equals(((Testcase)obj).getTestcaseFile());
    }

    private File getTestcaseFile() {
        return new File(this.home, this.getName() + ".testcase");
    }

    public void clearResultObjects() throws FilesNotDeletedException {
        this.watches.clear();
        if (this.responseWatches != null) {
            this.responseWatches.clear();
            this.responseWatches = null;
        }
        this.umlTree = null;
        System.gc();
        ArrayList undeletedFiles = new ArrayList();
        File folder = this.getGraphFolder();
        if (folder.exists()) {
            try {
                FileUtilities.deleteDirectory((File)folder);
            }
            catch (FilesNotDeletedException e) {
                undeletedFiles.addAll(e.getFiles());
                logger.warning(e.getLocalizedMessage());
            }
        }
        if ((folder = this.getTraceFolder()).exists()) {
            try {
                FileUtilities.deleteDirectory((File)folder);
            }
            catch (FilesNotDeletedException e) {
                undeletedFiles.addAll(e.getFiles());
                logger.warning(e.getLocalizedMessage());
            }
        }
        this.status = 7;
        this.lastRunDate = -1L;
        if (!undeletedFiles.isEmpty()) {
            throw new FilesNotDeletedException(undeletedFiles);
        }
    }

    public abstract boolean loadUmlTreeFromDisk();

    public void removeInspectionListeners() {
        if (this.umlTree != null) {
            this.removeInspectionListeners(this.umlTree);
        }
    }

    protected void removeInspectionListeners(UmlObject parent) {
        int length = parent.getChildCount();
        for (int i = 0; i < length; ++i) {
            UmlObject child = (UmlObject)parent.getChild(i);
            if (child instanceof InspectionObject) {
                ((InspectionObject)((Object)child)).clearInspectionListener();
            }
            this.removeInspectionListeners(child);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getActionScript(String scriptId) {
        String script = null;
        try {
            script = new ActionScriptHelper(this.getIOFile()).resolveActionScriptIOFromId(scriptId);
        }
        catch (IOException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "getActionScript", e);
        }
        catch (TransformerException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "getActionScript", e);
        }
        catch (TransformerLoadException e) {
            logger.severe("Caught a " + ((Object)((Object)e)).getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "getActionScript", e);
        }
        return script;
    }

    private void clearGraphFolder() {
        File graphFolder = this.getGraphFolder();
        if (graphFolder.exists()) {
            try {
                FileUtilities.deleteAllFiles((File)graphFolder);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    protected class TestcaseFilesFileFilter
    implements FileFilter {
        protected TestcaseFilesFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            boolean accepted;
            boolean bl = accepted = !file.isDirectory();
            if (accepted) {
                String name = file.getName();
                int index = name.indexOf(46);
                if (index != -1) {
                    name = name.substring(0, index);
                }
                accepted = name.equals(Testcase.this.getName());
            }
            return accepted;
        }
    }
}

