/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase;

import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TraceSettings;
import ch.e2e.builder.trace.testcase.request.Request;
import ch.e2e.builder.trace.testcase.response.AbstractResponseParser;
import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.event.EventController;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.FilesNotDeletedException;
import ch.e2e.resource.Properties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;

public abstract class AbstractAsynchronousTestcase
extends Testcase {
    private Properties properties;
    private Map<String, String> guardScripts = new HashMap<String, String>();

    public AbstractAsynchronousTestcase(File home, int type) {
        super(home.getName(), home, type);
        this.setStatus(type);
        File propertiesFile = new File(home, this.getName() + ".testcase");
        this.properties = new Properties(propertiesFile);
        this.traceSettings = new TraceSettings(this.properties);
        this.saveProperties();
    }

    protected abstract AbstractResponseParser getResponseParser();

    protected abstract TraceContainer createTraceContainer();

    @Override
    public void setHome(File newHome) {
        super.setHome(new File(newHome, this.home.getName()));
        this.properties.setPropertiesFile(new File(this.getHome(), this.properties.getPropertiesFile().getName()));
    }

    public void setResponse(Document response) {
        try {
            this.getTraceFolder().mkdirs();
            AbstractResponseParser responseParser = this.getResponseParser();
            responseParser.parse(response, this, this.createTraceContainer());
            this.setUmlTree(responseParser.getUmlTree());
            this.lastRunDate = responseParser.getLastRunDate();
            this.saveProperties();
        }
        catch (Exception e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "setResponse", e);
            EventController.fire((EventObject)new SendErrorEvent((Object)this, e.toString()));
        }
    }

    @Override
    public boolean isRPCEncoding() {
        return false;
    }

    @Override
    public void delete() throws FilesNotDeletedException {
        ArrayList undeletedFiles = new ArrayList();
        try {
            this.clearResultObjects();
        }
        catch (FilesNotDeletedException e) {
            undeletedFiles.addAll(e.getFiles());
            logger.info(e.getLocalizedMessage());
        }
        this.clear();
        try {
            FileUtilities.deleteDirectory((File)this.home);
        }
        catch (FilesNotDeletedException e) {
            undeletedFiles.addAll(e.getFiles());
            logger.warning(e.getLocalizedMessage());
        }
        if (!undeletedFiles.isEmpty()) {
            throw new FilesNotDeletedException(undeletedFiles);
        }
    }

    @Override
    public void saveRequest() {
    }

    @Override
    public Request getRequest() {
        return null;
    }

    @Override
    public long requestLastModified() {
        return 0L;
    }

    @Override
    public String getRequestData() {
        return null;
    }

    @Override
    public long responseLastModified() {
        return 0L;
    }

    @Override
    public String getResponseData() {
        return "";
    }

    public String getGuardScript(String guardId) {
        return this.guardScripts.get(guardId);
    }

    public void addGuardScript(String guardId, String scriptId) {
        this.guardScripts.put(guardId, scriptId);
    }

    protected void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    @Override
    protected void createDefaultProperties() {
    }

    protected void saveProperties() {
        try {
            this.traceSettings.write();
            this.properties.write(false);
        }
        catch (IOException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "saveProperties", e);
        }
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

