/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.request;

import ch.e2e.builder.trace.testcase.response.MockInfo;
import ch.e2e.builder.trace.tools.NamespacesManager;
import ch.e2e.dom.DomUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPResponse {
    private Document responseDocument;
    private Document traceDocument;
    private MockInfo mockInfo;

    public SOAPResponse(Document resultDocument, NamespacesManager namespacesManager) {
        this.responseDocument = resultDocument;
        NodeList traces = resultDocument.getElementsByTagNameNS("http://e2e.ch/bridge", "Trace");
        if (traces != null && traces.getLength() > 0) {
            this.traceDocument = DomUtilities.newDocument((String)"TraceResponse");
            Node importedTrace = this.traceDocument.importNode(traces.item(0), true);
            this.traceDocument.getDocumentElement().appendChild(importedTrace);
            traces.item(0).getParentNode().removeChild(traces.item(0));
        }
        this.mockInfo = this.createMockInfo(namespacesManager);
    }

    public SOAPResponse(Document responseDocument, Document traceDocument, NamespacesManager namespacesManager) {
        this.responseDocument = responseDocument;
        this.traceDocument = traceDocument;
        this.mockInfo = this.createMockInfo(namespacesManager);
    }

    public Document getResponseDocument() {
        return this.responseDocument;
    }

    public Document getTraceDocument() {
        return this.traceDocument;
    }

    public MockInfo getMockInfo() {
        return this.mockInfo;
    }

    private MockInfo createMockInfo(NamespacesManager namespacesManager) {
        MockInfo mockInfo = null;
        if (this.responseDocument != null) {
            Element mockElement;
            String uri = namespacesManager == null ? "http://schemas.xmlsoap.org/soap/envelope/" : namespacesManager.getSoapEnvelopeNamespaceUri();
            Element headerElement = (Element)this.responseDocument.getDocumentElement().getElementsByTagNameNS(uri, "Header").item(0);
            if (headerElement != null && (mockElement = (Element)headerElement.getElementsByTagNameNS("http://e2e.ch/bridge", "Mock").item(0)) != null) {
                mockInfo = new MockInfo(mockElement);
            }
        }
        return mockInfo;
    }
}

