/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.io;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.io.E2EBuilderFileView;
import ch.e2e.builder.base.io.E2EFileFilter;
import ch.e2e.builder.base.io.IODialogConstants;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;

public class E2EBuilderFileChooser
extends E2EBuilderDialog
implements IODialogConstants {
    protected JFileChooser fileChooser;
    E2EFileFilter[] fileFilter;
    private File selectedFile;
    private File[] selectedFiles;
    private boolean ignoreSetFileSelectionNull;

    protected E2EBuilderFileChooser(Frame parent, String internalTitle, String subtitle) {
        super(parent, E2EBuilderTranslator.getTranslation((String)"file.chooser.title"), internalTitle, subtitle, 3);
        this.createGui();
    }

    protected E2EBuilderFileChooser(Frame parent, String title, String internalTitle, String subtitle) {
        super(parent, title, internalTitle, subtitle, 3);
        this.createGui();
    }

    protected E2EBuilderFileChooser(FileSystemView fileSystemView, Frame parent, String title, String internalTitle, String subtitle) {
        super(parent, title, internalTitle, subtitle, 3);
        this.createGui(fileSystemView);
    }

    protected E2EBuilderFileChooser(File root, FileSystemView fileSystemView, Frame parent, String title, String internalTitle, String subtitle) {
        super(parent, title, internalTitle, subtitle, 3);
        this.createGui(root, fileSystemView);
    }

    protected E2EBuilderFileChooser(JDialog parent, String internalTitle, String subtitle) {
        super(parent, E2EBuilderTranslator.getTranslation((String)"file.chooser.title"), internalTitle, subtitle, 3);
        this.createGui();
    }

    protected E2EBuilderFileChooser(JDialog parent, String title, String internalTitle, String subtitle) {
        super(parent, title, internalTitle, subtitle, 3);
        this.createGui();
    }

    protected E2EBuilderFileChooser(FileSystemView fileSystemView, JDialog parent, String title, String internalTitle, String subtitle) {
        super(parent, title, internalTitle, subtitle, 3);
        this.createGui(fileSystemView);
    }

    protected E2EBuilderFileChooser(File root, FileSystemView fileSystemView, JDialog parent, String title, String internalTitle, String subtitle) {
        super(parent, title, internalTitle, subtitle, 3);
        this.createGui(root, fileSystemView);
    }

    public static E2EBuilderFileChooser createFileChooser(File root, FileSystemView fileSystemView, String title, String internalTitle, String subtitle) {
        Window parent = E2EBuilder.getInstance().getDialogParent();
        E2EBuilderFileChooser result = parent instanceof Frame ? new E2EBuilderFileChooser(root, fileSystemView, (Frame)parent, title, internalTitle, subtitle) : new E2EBuilderFileChooser(root, fileSystemView, (JDialog)parent, title, internalTitle, subtitle);
        return result;
    }

    public static E2EBuilderFileChooser createFileChooser(String internalTitle, String subtitle) {
        Window parent = E2EBuilder.getInstance().getDialogParent();
        E2EBuilderFileChooser result = parent instanceof Frame ? new E2EBuilderFileChooser((Frame)parent, internalTitle, subtitle) : new E2EBuilderFileChooser((JDialog)parent, internalTitle, subtitle);
        return result;
    }

    public static E2EBuilderFileChooser createFileChooser(String title, String internalTitle, String subtitle) {
        Window parent = E2EBuilder.getInstance().getDialogParent();
        E2EBuilderFileChooser result = parent instanceof Frame ? new E2EBuilderFileChooser((Frame)parent, title, internalTitle, subtitle) : new E2EBuilderFileChooser((JDialog)parent, title, internalTitle, subtitle);
        return result;
    }

    public File selectFile(File startDir) {
        return this.selectFile(startDir, false);
    }

    public File selectFile(File startDir, File defaultSelection, boolean includeAllFiles) {
        File result = null;
        this.initializeFileChooser(startDir, includeAllFiles, false);
        if (defaultSelection != null && defaultSelection.exists() && this.fileChooser.getFileFilter().accept(defaultSelection)) {
            this.fileChooser.setSelectedFile(defaultSelection);
            this.selectedFile = defaultSelection;
        } else {
            this.fileChooser.setSelectedFile(null);
            this.selectedFile = null;
        }
        this.setOkButtonEnabled();
        if (this.showDialogNoGuiUpdate() == 1) {
            result = this.fileChooser.getSelectedFile();
        }
        return result;
    }

    public File selectFile(File startDir, boolean includeAllFiles) {
        File result = null;
        this.initializeFileChooser(startDir, includeAllFiles, false);
        File file = this.fileChooser.getSelectedFile();
        if (file != null && file.exists() && file.getParentFile().equals(startDir)) {
            this.setOkButtonEnabled();
        } else {
            this.fileChooser.setSelectedFile(null);
            this.selectedFile = null;
            this.fileChooser.cancelSelection();
        }
        if (this.showDialogNoGuiUpdate() == 1) {
            result = this.fileChooser.getSelectedFile();
        }
        return result;
    }

    protected void initializeFileChooser(File startDir, boolean includeAllFiles, boolean multipleFiles) {
        this.fileChooser.setCurrentDirectory(startDir);
        FileFilter selectedFilter = this.fileChooser.getFileFilter();
        this.fileChooser.setAcceptAllFileFilterUsed(includeAllFiles);
        this.fileChooser.setMultiSelectionEnabled(multipleFiles);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setDialogType(0);
        this.updateGui(true, true, true);
        this.fileChooser.setFileFilter(selectedFilter);
    }

    public File[] selectFiles(File startDir, boolean includeAllFiles) {
        boolean ok;
        File[] result = null;
        this.initializeFileChooser(startDir, includeAllFiles, true);
        boolean bl = ok = this.selectedFiles != null && this.selectedFiles.length > 0;
        if (ok) {
            FileFilter fileFilter = this.fileChooser.getFileFilter();
            for (int i = 0; ok && i < this.selectedFiles.length; ++i) {
                ok = fileFilter.accept(this.selectedFiles[i]);
            }
            if (!ok) {
                this.selectedFiles = null;
            }
        }
        this.fileChooser.setSelectedFiles(this.selectedFiles);
        this.setOkButtonEnabled(ok);
        if (this.showDialog() == 1) {
            result = this.fileChooser.getSelectedFiles();
        }
        return result;
    }

    public File selectDirectory(File startDir) {
        return this.selectDirectory(startDir, startDir.getParentFile());
    }

    public File selectDirectory(File startDir, File currentDirectory) {
        File result = null;
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setCurrentDirectory(currentDirectory);
        this.fileChooser.setSelectedFile(startDir);
        this.fileChooser.setDialogType(0);
        if (this.showDialog() == 1) {
            result = this.fileChooser.getSelectedFile();
        }
        return result;
    }

    public void setFileFilter(E2EFileFilter[] fileFilter, E2EFileFilter selectedFilter) {
        FileFilter[] choosableFilter;
        for (FileFilter fileFilter2 : choosableFilter = this.fileChooser.getChoosableFileFilters()) {
            this.fileChooser.removeChoosableFileFilter(fileFilter2);
        }
        E2EFileFilter[] e2EFileFilterArray = this.fileFilter = fileFilter == null || fileFilter.length == 0 ? null : fileFilter;
        if (fileFilter != null) {
            for (FileFilter fileFilter3 : fileFilter) {
                this.fileChooser.addChoosableFileFilter(fileFilter3);
            }
        }
        this.fileChooser.setFileFilter(selectedFilter);
    }

    public void setFileFilter(E2EFileFilter selectedFilter) {
        this.fileChooser.setFileFilter(selectedFilter);
    }

    public void setFileView(FileView fileView) {
        this.fileChooser.setFileView(fileView);
    }

    public void setFileSystemView(FileSystemView fileSystemView) {
        this.fileChooser.setFileSystemView(fileSystemView);
    }

    protected File getSelectedFile() {
        return this.selectedFile;
    }

    protected void setOkButtonEnabled() {
        File file = this.fileChooser.getSelectedFile();
        boolean enabled = false;
        if (file != null) {
            if (this.fileFilter == null) {
                enabled = this.fileChooser.getFileSelectionMode() != 0 || file.isFile();
            } else if (this.fileChooser.isAcceptAllFileFilterUsed()) {
                enabled = true;
            } else {
                for (int i = 0; i < this.fileFilter.length && !enabled; ++i) {
                    enabled = this.fileFilter[i].accept(file) && (this.fileChooser.getFileSelectionMode() != 0 || file.isFile());
                }
            }
        }
        this.setOkButtonEnabled(enabled);
    }

    protected void addFileChooser() {
        this.add(this.fileChooser, "Center");
    }

    protected ActionListener getFileChooserAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("CancelSelection")) {
                    E2EBuilderFileChooser.this.cancelDialog();
                } else {
                    E2EBuilderFileChooser.this.okDialog();
                }
            }
        };
    }

    private void createGui() {
        this.fileChooser = new JFileChooser(){

            @Override
            public void setSelectedFile(File file) {
                super.setSelectedFile(file);
            }

            @Override
            public void setFileFilter(FileFilter filter) {
                E2EBuilderFileChooser.this.ignoreSetFileSelectionNull = true;
                super.setFileFilter(filter);
                E2EBuilderFileChooser.this.ignoreSetFileSelectionNull = false;
            }
        };
        this.initializeGui();
    }

    private void createGui(File root, FileSystemView fileSystemView) {
        this.fileChooser = new JFileChooser(root, fileSystemView){

            @Override
            public void setSelectedFile(File file) {
                super.setSelectedFile(file);
            }

            @Override
            public void setFileFilter(FileFilter filter) {
                E2EBuilderFileChooser.this.ignoreSetFileSelectionNull = true;
                super.setFileFilter(filter);
                E2EBuilderFileChooser.this.ignoreSetFileSelectionNull = false;
            }
        };
        this.initializeGui();
    }

    private void createGui(FileSystemView fileSystemView) {
        this.fileChooser = new JFileChooser(fileSystemView){

            @Override
            public void setSelectedFile(File file) {
                super.setSelectedFile(file);
            }

            @Override
            public void setFileFilter(FileFilter filter) {
                E2EBuilderFileChooser.this.ignoreSetFileSelectionNull = true;
                super.setFileFilter(filter);
                E2EBuilderFileChooser.this.ignoreSetFileSelectionNull = false;
            }
        };
        this.initializeGui();
    }

    private void initializeGui() {
        this.fileChooser.setLocale(this.getLocale());
        this.fileChooser.setFileHidingEnabled(false);
        this.fileChooser.addPropertyChangeListener("directoryChanged", this.getSelectedDirectoryChangedListener());
        this.fileChooser.addPropertyChangeListener("SelectedFileChangedProperty", this.getSelectedFileChangedListener());
        this.fileChooser.addPropertyChangeListener("SelectedFilesChangedProperty", this.getSelectedFilesChangedListener());
        this.fileChooser.addActionListener(this.getFileChooserAction());
        this.fileChooser.setControlButtonsAreShown(false);
        this.fileChooser.setFileView((FileView)((Object)E2EBuilderFileView.getInstance()));
        this.addFileChooser();
    }

    private PropertyChangeListener getSelectedFilesChangedListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null && !E2EBuilderFileChooser.this.ignoreSetFileSelectionNull) {
                    E2EBuilderFileChooser.access$302(E2EBuilderFileChooser.this, null);
                } else if (evt.getNewValue() != null) {
                    E2EBuilderFileChooser.access$302(E2EBuilderFileChooser.this, (File[])evt.getNewValue());
                }
                E2EBuilderFileChooser.this.setOkButtonEnabled();
            }
        };
    }

    private PropertyChangeListener getSelectedFileChangedListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null && !E2EBuilderFileChooser.this.ignoreSetFileSelectionNull) {
                    E2EBuilderFileChooser.this.selectedFile = null;
                } else if (evt.getNewValue() != null) {
                    E2EBuilderFileChooser.this.selectedFile = (File)evt.getNewValue();
                }
                E2EBuilderFileChooser.this.setOkButtonEnabled();
            }
        };
    }

    private PropertyChangeListener getSelectedDirectoryChangedListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (E2EBuilderFileChooser.this.fileChooser.getFileSelectionMode() == 0) {
                    E2EBuilderFileChooser.this.fileChooser.setSelectedFile(null);
                }
                E2EBuilderFileChooser.this.setOkButtonEnabled();
            }
        };
    }

    static /* synthetic */ File[] access$302(E2EBuilderFileChooser x0, File[] x1) {
        x0.selectedFiles = x1;
        return x1;
    }
}

