/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui.toolbar;

import ch.e2e.builder.base.event.PrintEvent;
import ch.e2e.builder.base.event.RefreshEvent;
import ch.e2e.builder.base.event.ShowAboutBuilderEvent;
import ch.e2e.builder.base.event.ToggleMenuEvent;
import ch.e2e.builder.base.event.ToggleMessageViewEvent;
import ch.e2e.builder.base.gui.menu.E2EBuilderMenuBar;
import ch.e2e.builder.base.gui.menu.PredefinedMenuItems;
import ch.e2e.builder.base.project.event.ProjectEditEvent;
import ch.e2e.builder.base.project.event.ProjectNewEvent;
import ch.e2e.builder.base.project.event.ProjectOpenEvent;
import ch.e2e.builder.base.resource.E2EBuilderIcons;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.event.EventController;
import com.jidesoft.action.CommandBar;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideToggleButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;

public class E2EBuilderToolBar
extends CommandBar
implements E2EBuilderIcons,
PredefinedMenuItems {
    private HashMap<String, JideButton> buttons = new HashMap();

    public E2EBuilderToolBar() {
        this(null);
    }

    public E2EBuilderToolBar(E2EBuilderMenuBar menuBar) {
        super("e2ebuilder.toolbar");
        this.setInitSide(1);
        this.setInitIndex(1);
        this.setInitSubindex(0);
        this.setFloatable(true);
        this.setHidable(false);
        this.addProjectSection();
        this.addSeparator();
        this.addViewSection();
        this.addSeparator();
        String tooltip = E2EBuilderTranslator.getTranslation((String)"menu.help.about.tooltip");
        this.addButton(new String[]{"menu.help", "menu.help.about"}, ABOUT_ICON, tooltip, (EventObject)((Object)new ShowAboutBuilderEvent()));
        if (menuBar != null) {
            this.setEnabled(menuBar);
        }
    }

    public void setItemEnabled(String[] menuPath, boolean enabled) {
        JideButton button = this.buttons.get(this.getPathString(menuPath));
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    public void setItemSelected(String[] menuPath, boolean selected) {
        JideButton button = this.buttons.get(this.getPathString(menuPath));
        if (button != null) {
            button.setSelected(selected);
        }
    }

    public void setEnabled(E2EBuilderMenuBar menuBar) {
        Iterator<Map.Entry<String, JideButton>> iterator = this.buttons.entrySet().iterator();
        while (iterator.hasNext()) {
            String[] path;
            Boolean enabled;
            Map.Entry<String, JideButton> entry;
            entry.getValue().setEnabled((enabled = menuBar.isItemEnabled(path = (entry = iterator.next()).getKey().split("/"))) == null || enabled != false);
            Boolean selected = menuBar.isItemSelected(path);
            entry.getValue().setSelected(selected == null || selected != false);
        }
    }

    private void addProjectSection() {
        String tooltip = E2EBuilderTranslator.getTranslation((String)"menu.project.print.tooltip");
        this.addButton(new String[]{"menu.project", "menu.project.print"}, PRINT_ICON, tooltip, (EventObject)((Object)new PrintEvent())).setEnabled(false);
        this.addSeparator();
        tooltip = E2EBuilderTranslator.getTranslation((String)"menu.project.new.tooltip");
        this.addButton(new String[]{"menu.project", "menu.project.new"}, PROJECT_NEW_ICON, tooltip, (EventObject)((Object)new ProjectNewEvent()));
        tooltip = E2EBuilderTranslator.getTranslation((String)"menu.project.open.tooltip");
        this.addButton(new String[]{"menu.project", "menu.project.open"}, PROJECT_OPEN_ICON, tooltip, (EventObject)((Object)new ProjectOpenEvent()));
        tooltip = E2EBuilderTranslator.getTranslation((String)"menu.project.preferences.tooltip");
        this.addButton(new String[]{"menu.project", "menu.project.preferences"}, PROJECT_PREFERENCES_ICON, tooltip, (EventObject)((Object)new ProjectEditEvent()));
    }

    private void addViewSection() {
        String tooltip = E2EBuilderTranslator.getTranslation((String)"menu.view.refresh.tooltip");
        this.addButton(new String[]{"menu.view", "menu.view.refresh"}, VIEW_REFRESH_ICON, tooltip, (EventObject)((Object)new RefreshEvent()));
        tooltip = E2EBuilderTranslator.getTranslation((String)"menu.view.toggle.messageview.tooltip");
        this.addButton(new String[]{"menu.view", "menu.view.toggle.messageview"}, VIEW_TOGGLE_MESSAGEVIEW_ICON, tooltip, (EventObject)((Object)new ToggleMessageViewEvent()));
    }

    private JideButton addButton(String[] menuPath, Icon icon, String tooltip, EventObject event) {
        Object button = event instanceof ToggleMenuEvent ? new ToggleToolbarButton(icon, (ToggleMenuEvent)((Object)event)) : new ToolbarButton(icon, event);
        String key = this.getPathString(menuPath);
        button.setToolTipText(tooltip);
        button.setName(key);
        this.buttons.put(key, (JideButton)button);
        this.add((Component)button);
        return button;
    }

    private String getPathString(String[] pathArray) {
        StringBuffer path = new StringBuffer();
        for (String aPathArray : pathArray) {
            path.append(aPathArray).append("/");
        }
        return path.toString();
    }

    private class ToggleToolbarButton
    extends JideToggleButton {
        private ToggleToolbarButton(Icon icon, final ToggleMenuEvent event) {
            super(icon);
            this.setFocusable(false);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    event.setState(ToggleToolbarButton.this.isSelected());
                    EventController.fire((EventObject)((Object)event));
                }
            });
        }
    }

    private class ToolbarButton
    extends JideButton {
        private ToolbarButton(Icon icon, final EventObject event) {
            super(icon);
            this.setFocusable(false);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventController.fire((EventObject)event);
                }
            });
        }
    }
}

