/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.application;

import ch.e2e.io.OutputDestination;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class E2EBuilderLogfile
implements OutputDestination {
    private File logfile;

    public E2EBuilderLogfile() {
        File path = new File(System.getProperty("user.home"), ".e2ebuilder");
        if (!path.exists()) {
            path.mkdirs();
        }
        this.logfile = new File(path, "e2ebuilder.analyzer.log");
    }

    public void println() {
        this.printMessage("\n");
    }

    public void println(String message) {
        this.printMessage(message);
    }

    public void print(String message) {
        this.printMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMessage(String message) {
        this.checkLogfile();
        PrintWriter logWriter = null;
        try {
            logWriter = new PrintWriter((Writer)new FileWriter(this.logfile, true), true);
            logWriter.print(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (logWriter != null) {
                logWriter.flush();
                logWriter.close();
            }
        }
    }

    private void checkLogfile() {
        long length = this.logfile.length();
        if (length > 5000000L) {
            File newLogfile = new File(this.logfile.getParentFile(), this.logfile.getName() + ".bak");
            if (newLogfile.exists()) {
                newLogfile.delete();
            }
            this.logfile.renameTo(newLogfile);
        }
    }
}

