/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.model;

import ch.e2e.builder.analyzer.model.TransactionLogEntry;
import ch.e2e.builder.analyzer.model.TransactionLogLifeline;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TransactionLogCall {
    private TransactionLogEntry call;
    private TransactionLogEntry reply;
    private int duration = 0;
    private boolean failed = false;
    private String error;
    private TransactionLogCall parent;
    private List<TransactionLogCall> children = new ArrayList<TransactionLogCall>();
    private String lifelineKey;
    private String lifelineName;
    private TransactionLogLifeline lifeline;

    public TransactionLogCall(TransactionLogEntry call) {
        this.setCall(call);
    }

    public TransactionLogEntry getCall() {
        return this.call;
    }

    public void setCall(TransactionLogEntry call) {
        this.call = call;
        if (this.isBackendCall()) {
            String id = call.getParam_2();
            this.lifelineKey = this.lifelineName = (id == null ? "" : id) + ":" + call.getDomain();
        } else {
            this.lifelineKey = call.getComponentName();
            this.lifelineName = call.getOperation();
        }
    }

    public TransactionLogEntry getReply() {
        return this.reply;
    }

    public void setReply(TransactionLogEntry reply) {
        this.reply = reply;
        this.duration = reply.getElapsedTime() - this.call.getElapsedTime();
        this.failed = reply.hasState(TransactionLogEntry.State.ERROR);
        if (this.failed) {
            this.error = reply.getParam_2();
        }
        reply.setDuration(this.duration);
    }

    public String getRequestId() {
        return this.call.getRequestId();
    }

    public String getLifelineId() {
        return this.lifelineKey;
    }

    public String getLifelineName() {
        return this.lifelineName;
    }

    public TransactionLogLifeline getLifeline() {
        return this.lifeline;
    }

    public void setLifeline(TransactionLogLifeline lifeline) {
        this.lifeline = lifeline;
    }

    public Date getStartDate() {
        return this.call.getDate();
    }

    public Date getEndDate() {
        return this.call.getDate();
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean hasFailed() {
        return this.failed;
    }

    public String getError() {
        return this.error;
    }

    public boolean isServiceCall() {
        return this.call.isServiceEnter();
    }

    public boolean isBackendCall() {
        return this.call.isBackend();
    }

    public boolean isPStateCall() {
        return this.call.isPState();
    }

    public TransactionLogCall getParent() {
        return this.parent;
    }

    public void setParent(TransactionLogCall parent) {
        this.parent = parent;
    }

    public void addChild(TransactionLogCall child) {
        this.children.add(child);
        child.setParent(this);
        child.setLifeline(this.getLifeline());
    }
}

