/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.importer;

import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.application.TransactionParticipant;
import ch.e2e.builder.base.application.abstracts.DoTransactionEvent;
import ch.e2e.builder.base.io.E2EFileFilter;
import ch.e2e.builder.base.io.FileService;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.importer.WSDLImport;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.builder.traceviewer.execute.soap.ImportTestcasesTransaction;
import ch.e2e.builder.traceviewer.importer.ImportTestcasesEvent;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.EventObject;
import javax.swing.tree.TreePath;

public class TestcasesImporter
implements EventExecuter,
TransactionParticipant {
    private static final String KEY_LOG_IMPORT = "log_import";
    private final E2EBuilderModule module;
    private final WSDLImport.Data data;

    public TestcasesImporter(E2EBuilderModule module, WSDLImport.Data data) {
        this.module = module;
        this.data = data;
    }

    public TestcasesImporter(E2EBuilderModule module) {
        this(module, null);
    }

    public void execute(EventObject event) throws EventExecutionVetoException {
        this.importTestcases(((ImportTestcasesEvent)((Object)event)).getPath());
    }

    public void transactionFinished() {
        File file = this.selectLogFile();
        if (file != null) {
            EventController.fire((EventObject)new DoTransactionEvent((Object)this, (E2EBuilderTransaction)new ImportTestcasesTransaction(this.module), (Object)new Data(file, (TestcaseContainer)this.data.getWsdlFolder(), this.data.getProjectName())));
        }
    }

    private void importTestcases(TreePath path) {
        File file = this.selectLogFile();
        if (file != null && path.getLastPathComponent() instanceof TestcaseContainer) {
            EventController.fire((EventObject)new DoTransactionEvent((Object)this, (E2EBuilderTransaction)new ImportTestcasesTransaction(this.module), (Object)new Data(file, (TestcaseContainer)path.getLastPathComponent())));
        }
    }

    private File selectLogFile() {
        File file = FileService.selectFile((File)this.module.getProjectProperty(KEY_LOG_IMPORT, new File(System.getProperty("ch.e2e.builder.base.repository"))), (E2EFileFilter[])new FileFilter[]{new FileFilter("log", this.module.getTranslation("log.importer.file.filter.description"))}, (String)this.module.getTranslation("log.importer.title"), (String)this.module.getTranslation("log.importer.file.subtitle"), (boolean)true);
        if (file != null && file.canRead()) {
            try {
                this.module.setProjectProperty(KEY_LOG_IMPORT, (Object)file);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            file = null;
        }
        return file;
    }

    public void transactionStarts() {
    }

    public void transactionStarted() {
    }

    public boolean isRemoveAfterAction() {
        return true;
    }

    protected static class FileFilter
    extends E2EFileFilter {
        private final String extension;
        private final String description;

        public FileFilter(String extension, String description) {
            this.extension = extension;
            this.description = description;
        }

        public String getDefaultExtension() {
            return this.extension;
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(this.extension);
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class Data {
        private final File logFile;
        private final TestcaseContainer testcaseContainer;
        private final String projectName;

        public Data(File logFile, TestcaseContainer testcaseContainer, String projectName) {
            this.logFile = logFile;
            this.testcaseContainer = testcaseContainer;
            this.projectName = projectName;
        }

        public Data(File logFile, TestcaseContainer testcaseContainer) {
            this(logFile, testcaseContainer, null);
        }

        public File getLogFile() {
            return this.logFile;
        }

        public TestcaseContainer getTestcaseContainer() {
            return this.testcaseContainer;
        }

        public String getProjectName() {
            return this.projectName;
        }
    }
}

