/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute.soap;

import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.importer.WSDLImport;
import ch.e2e.builder.trace.testcase.AbstractAsynchronousTestcaseRoot;
import ch.e2e.builder.trace.testcase.AbstractWSDLFolder;
import ch.e2e.util.StringTools;
import ch.e2e.xuml.settings.Settings;
import ch.e2e.xuml.settings.SettingsException;
import ch.e2e.xuml.substitutor.PlaceholderSubstitutorException;
import ch.e2e.xuml.template.TemplateProcessingException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class ImportWSDLTransaction
extends E2EBuilderTransaction {
    private final E2EBuilderModule module;

    public ImportWSDLTransaction(E2EBuilderModule module) {
        this.module = module;
    }

    public Object doTransaction(Object transactionData) throws Throwable {
        WSDLImport.Data wsdlImport = (WSDLImport.Data)transactionData;
        if ("file".equals(wsdlImport.getUrl().getProtocol()) && wsdlImport.getUrl().getPath().endsWith("rep")) {
            this.importFromRepository(wsdlImport);
        } else {
            this.importFromUrl(wsdlImport);
        }
        return null;
    }

    public void prepareTransaction() {
    }

    public void setTransactionResult(Object transactionResult) {
        this.module.refresh();
    }

    public String getDescription() {
        return "WSDL Import";
    }

    public boolean doErrorHandling(Throwable error) {
        if (error instanceof WSDLImport.ImportError) {
            String msg = this.module.getTranslation(error.getMessage());
            msg = StringTools.replaceProperty((String)msg, (String)"repository", (String)((WSDLImport.ImportError)error).getRepository());
            this.module.showError(msg);
        } else if (error instanceof WSDLImport.ImportWarning) {
            String msg = this.module.getTranslation(error.getMessage());
            msg = StringTools.replaceProperty((String)msg, (String)"repository", (String)((WSDLImport.ImportWarning)error).getRepository());
            this.module.showWarning(msg);
            this.module.refresh();
        } else if (!(error instanceof WSDLImport.XSLTErrorException)) {
            this.module.showError(error.getMessage() == null ? error.getClass().getName() : error.getMessage());
        }
        return false;
    }

    private void importFromUrl(WSDLImport.Data wsdlImport) throws IOException, WSDLImport.XSLTErrorException, TransformerException {
        WSDLImport.importWSDLFiles((WSDLImport.ImportSource)new WSDLImport.URLImportSource(wsdlImport.getUrl()), null, null, (AbstractWSDLFolder)wsdlImport.getWsdlFolder(), (boolean)wsdlImport.isMerge(), (int)wsdlImport.getNestingLevel());
    }

    private void importFromRepository(WSDLImport.Data wsdlImport) throws URISyntaxException, IOException, ParserConfigurationException, SAXException, TransformerException, WSDLImport.XSLTErrorException, WSDLImport.ImportError, WSDLImport.ImportWarning, SettingsException, TemplateProcessingException, PlaceholderSubstitutorException {
        File file = new File(wsdlImport.getUrl().toURI());
        Settings settings = ImportWSDLTransaction.getSettingsFromRepository(file);
        WSDLImport.importSyncFromRepository((File)file, (AbstractWSDLFolder)wsdlImport.getWsdlFolder(), (boolean)wsdlImport.isMerge(), (int)wsdlImport.getNestingLevel(), (String)wsdlImport.getHost(), (Settings)settings);
        WSDLImport.importAsyncFromRepository((File)file, (AbstractAsynchronousTestcaseRoot)wsdlImport.getAsynchronousTestcaseRoot(), (String)wsdlImport.getProjectName(), (String)wsdlImport.getHost(), (Settings)settings);
    }

    private static Settings getSettingsFromRepository(File file) throws SettingsException {
        return Settings.createFromRepositoryWithChangedSettings((File)file);
    }
}

