/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui.swing;

import ch.e2e.builder.regtest.gui.swing.AdvancedOptionsDialog;
import ch.e2e.builder.regtest.gui.swing.OptionComponent;
import ch.e2e.builder.regtest.gui.swing.OptionComponentFactory;
import ch.e2e.resource.Translator;
import ch.e2e.test.options.IntegerOption;
import ch.e2e.test.options.Option;
import ch.e2e.test.options.OptionComparator;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class OptionPanel
extends JPanel {
    private HashMap<String, OptionComponent> optionComponents;
    private JButton advancedButton;
    private Collection<Option> advancedOptions;
    private boolean advancedOptionsChanged;
    private AdvancedOptionsDialog advancedOptionsDlg;
    private Dialog parent;
    private Icon icon;
    private boolean ignoreRequired;

    public OptionPanel(Dialog parent, Icon icon, Translator translator) {
        this.parent = parent;
        this.icon = icon;
        this.createGui(translator);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                boolean dummy = false;
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    public HashMap<String, OptionComponent> setOptions(Collection<Option> options, boolean readOnly, boolean setDefaultValue) {
        return this.setOptions(options, new ArrayList<Option>(), readOnly, setDefaultValue);
    }

    public void setNameFieldSelected() {
        OptionComponent nameField = this.optionComponents.get("key.option.test.name");
        if (nameField != null) {
            nameField.requestFocus();
            nameField.getComponent().addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    boolean dummy = false;
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            });
        }
    }

    public HashMap<String, OptionComponent> setOptions(Collection<Option> options, Collection<Option> advancedOptions, boolean readOnly, boolean setDefaultValue) {
        if (this.advancedOptionsDlg == null && advancedOptions.size() > 0) {
            this.advancedOptionsDlg = new AdvancedOptionsDialog(this.parent, this.icon);
        }
        if (this.advancedOptionsDlg != null) {
            this.advancedOptionsDlg.setOptions(advancedOptions, readOnly, setDefaultValue);
        }
        this.advancedOptions = advancedOptions;
        this.optionComponents = new HashMap();
        TreeSet<Option> optionSet = new TreeSet<Option>((Comparator<Option>)new OptionComparator());
        optionSet.addAll(options);
        this.removeAll();
        ArrayList<OptionComponent> optionPanes = new ArrayList<OptionComponent>();
        for (Option option : optionSet) {
            try {
                OptionComponent component = OptionComponentFactory.getInstance().getOptionComponent(option, setDefaultValue, this.ignoreRequired);
                if (component == null) continue;
                component.setReadOnly(readOnly);
                if (option.isVisible()) {
                    optionPanes.add(component);
                }
                this.optionComponents.put(option.getKey(), component);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 18;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        int length = optionPanes.size() - 1;
        if (length >= 0) {
            for (int i = 0; i < length; ++i) {
                OptionComponent optionComponent = (OptionComponent)optionPanes.get(i);
                this.setFillConstraint((Option)optionComponent.getOption(), c);
                c.weighty = optionComponent.getWeightY();
                this.add((Component)optionComponent.getComponent(), c);
            }
            if (advancedOptions.size() == 0) {
                c.weighty = 1.0;
            }
            this.setFillConstraint((Option)((OptionComponent)optionPanes.get(length)).getOption(), c);
            this.add((Component)((OptionComponent)optionPanes.get(length)).getComponent(), c);
        }
        if (advancedOptions.size() > 0) {
            c.weighty = 1.0;
            c.fill = 0;
            c.anchor = 14;
            this.add((Component)this.advancedButton, c);
        }
        return this.optionComponents;
    }

    public void persist(boolean forced) {
        for (OptionComponent component : this.optionComponents.values()) {
            component.persist(forced);
        }
        if (this.advancedOptionsChanged) {
            this.advancedOptionsDlg.persist(forced);
        }
    }

    public boolean isIgnoreRequired() {
        return this.ignoreRequired;
    }

    public void setIgnoreRequired(boolean ignoreRequired) {
        this.ignoreRequired = ignoreRequired;
    }

    private void createGui(Translator translator) {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.advancedButton = new JButton(translator.getTranslation("option.panel.button.advanced"));
        this.advancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionPanel.this.showAdvancedOptions();
            }
        });
    }

    private void setFillConstraint(Option option, GridBagConstraints c) {
        c.fill = option instanceof IntegerOption ? 3 : 1;
    }

    private void showAdvancedOptions() {
        this.advancedOptionsChanged = this.advancedOptionsDlg.editAdvancedOptions();
    }
}

