/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.event.DataChangesAcceptedEvent;
import ch.e2e.builder.regtest.event.TestUnitFinishedEvent;
import ch.e2e.builder.regtest.event.TestUnitStartEvent;
import ch.e2e.builder.regtest.gui.CounterPanel;
import ch.e2e.builder.regtest.gui.DiffPane;
import ch.e2e.builder.regtest.gui.SelectedTestView;
import ch.e2e.builder.regtest.gui.TestProgressBar;
import ch.e2e.builder.regtest.testsuite.LibrariesRoot;
import ch.e2e.builder.regtest.testsuite.Testcase;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.test.E2ETask;
import ch.e2e.test.E2ETest;
import ch.e2e.test.E2ETestcase;
import ch.e2e.test.ErrorDetail;
import ch.e2e.test.ErrorElement;
import ch.e2e.test.TestEndEvent;
import ch.e2e.test.TestErrorEvent;
import ch.e2e.test.TestFailureEvent;
import ch.e2e.test.TestSelectedEvent;
import ch.e2e.test.TestStartEvent;
import ch.e2e.test.Utilities;
import ch.e2e.test.junit.TestUnit;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import junit.framework.Test;
import junit.framework.TestResult;

public class TestView
extends JSplitPane
implements EventExecuter,
TreeSelectionListener {
    private TestProgressBar progressIndicator;
    private CounterPanel counterPanel;
    private TestResult testResult;
    private TestUnit testUnit;
    private DiffPane diffPane;
    private SelectedTestView selectedTestView;
    private int taskCount;
    private JLabel executingLabel;
    private JButton cancelButton;
    private int total = 0;

    public TestView(E2EBuilderModule module) {
        super(0, true);
        this.createGui(module);
        this.addEventHandler();
    }

    public void execute(EventObject event) {
        this.progressIndicator.testSelected(((TestSelectedEvent)event).getTests());
        this.total = this.counterPanel.testSelected(((TestSelectedEvent)event).getTests());
        this.selectedTestView.testSelected((TestSelectedEvent)event);
    }

    public void clear() {
        this.progressIndicator.reset();
        this.counterPanel.reset();
        this.taskCount = 0;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (e.getNewLeadSelectionPath() == null) {
            this.diffPane.clear();
            this.selectedTestView.clear();
        } else {
            Object lastPathComponent = e.getNewLeadSelectionPath().getLastPathComponent();
            Testcase testcase = null;
            ErrorDetail errorDetail = null;
            if (lastPathComponent instanceof Testcase && !LibrariesRoot.isInLibraryTree((Testcase)lastPathComponent)) {
                testcase = (Testcase)lastPathComponent;
            } else if (lastPathComponent instanceof ErrorElement) {
                testcase = (Testcase)((ErrorElement)lastPathComponent).getOwner().getOwner();
            } else if (lastPathComponent instanceof ErrorDetail) {
                errorDetail = ((ErrorDetail)lastPathComponent).hasDiffInfo() ? (ErrorDetail)lastPathComponent : null;
                for (TreePath parentPath = e.getNewLeadSelectionPath().getParentPath(); parentPath != null && testcase == null; parentPath = parentPath.getParentPath()) {
                    lastPathComponent = parentPath.getLastPathComponent();
                    Testcase testcase2 = testcase = lastPathComponent instanceof Testcase ? (Testcase)lastPathComponent : null;
                    if (errorDetail != null || !(lastPathComponent instanceof ErrorDetail)) continue;
                    errorDetail = ((ErrorDetail)lastPathComponent).hasDiffInfo() ? (ErrorDetail)lastPathComponent : null;
                }
            }
            if (testcase == null) {
                this.diffPane.clear();
            } else {
                Utilities.replaceProperties((E2ETestcase)testcase);
                this.diffPane.setTestcase(testcase, errorDetail);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.selectedTestView.setEnabled(enabled);
        this.progressIndicator.setEnabled(enabled);
        this.counterPanel.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    private void createGui(E2EBuilderModule module) {
        JPanel upper = new JPanel(new GridBagLayout());
        this.executingLabel = new JLabel("");
        JLabel progressLabel = ComponentFactory.createLabel((String)"Test progress ...", (E2EBuilderModule)module);
        this.progressIndicator = new TestProgressBar();
        this.counterPanel = new CounterPanel(module);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 17;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 3, 5, 3);
        c.gridwidth = 1;
        c.weightx = 0.0;
        upper.add((Component)this.executingLabel, c);
        c.gridwidth = 0;
        this.cancelButton = ComponentFactory.createButton((String)"cancel.test", (E2EBuilderModule)module);
        this.cancelButton.setEnabled(false);
        c.anchor = 13;
        c.weightx = 1.0;
        c.fill = 0;
        upper.add((Component)this.cancelButton, c);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestView.this.cancelTestExecution();
            }
        });
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 3, 5, 3);
        upper.add((Component)progressLabel, c);
        upper.add((Component)this.progressIndicator, c);
        upper.add((Component)this.counterPanel, c);
        upper.add((Component)new JSeparator(), c);
        c.fill = 1;
        c.weighty = 1.0;
        this.diffPane = new DiffPane(module);
        this.selectedTestView = new SelectedTestView(module, this, this.diffPane);
        upper.add((Component)((Object)this.selectedTestView), c);
        this.setLeftComponent(upper);
        this.setRightComponent((Component)((Object)this.diffPane));
    }

    private void cancelTestExecution() {
        if (this.testUnit != null) {
            this.testUnit.cancel();
        }
    }

    private void addEventHandler() {
        EventController.register((EventExecuter)this, TestSelectedEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestView.this.testUnitStarting((TestUnitStartEvent)event);
            }
        }, TestUnitStartEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestView.this.testUnitFinished((TestUnitFinishedEvent)event);
            }
        }, TestUnitFinishedEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestView.this.testError((TestErrorEvent)event);
            }
        }, TestErrorEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestView.this.testStart((TestStartEvent)event);
            }
        }, TestStartEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestView.this.testFailure((TestFailureEvent)event);
            }
        }, TestFailureEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestView.this.testEnd(((TestEndEvent)event).getTest());
            }
        }, TestEndEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestView.this.dataChangesAccepted(((DataChangesAcceptedEvent)event).getTestcase());
            }
        }, DataChangesAcceptedEvent.class);
    }

    private void dataChangesAccepted(E2ETestcase testcase) {
        this.clear();
        this.selectedTestView.refresh(testcase);
    }

    private void testStart(TestStartEvent testStartEvent) {
        this.executingLabel.setText("Executing " + testStartEvent.getTest().toString());
    }

    private void testError(TestErrorEvent testErrorEvent) {
        this.counterPanel.setErrorValue(this.testResult.errorCount());
        this.testUnit.addError(testErrorEvent.getTest());
    }

    private void testFailure(TestFailureEvent testFailureEvent) {
        this.counterPanel.setFailureValue(this.testResult.failureCount());
        this.testUnit.addFailure(testFailureEvent.getTest());
    }

    private void testUnitStarting(TestUnitStartEvent testUnitStartEvent) {
        this.testResult = testUnitStartEvent.getTestResult();
        this.testUnit = testUnitStartEvent.getTestUnit();
        this.taskCount = 0;
        this.counterPanel.reset();
        this.counterPanel.setTotal(this.total);
        this.counterPanel.testUnitStarting();
        this.progressIndicator.reset();
        this.progressIndicator.start(this.total);
        this.cancelButton.setEnabled(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestView.this.diffPane.clear();
            }
        });
    }

    private void testUnitFinished(TestUnitFinishedEvent testUnitFinishedEvent) {
        this.executingLabel.setText("");
        this.cancelButton.setEnabled(false);
        this.counterPanel.testUnitFinished();
    }

    private void testEnd(Test test) {
        if (test instanceof E2ETask) {
            ++this.taskCount;
        }
        final int runCount = this.testResult.runCount() - this.taskCount;
        final boolean successful = !(test instanceof E2ETest) || ((E2ETest)test).getErrors().size() == 0;
        this.testUnit.addRunTest(test);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestView.this.counterPanel.setRunValue(runCount);
                TestView.this.progressIndicator.step(runCount, successful);
                SwingUtilities.updateComponentTreeUI(TestView.this.progressIndicator);
            }
        });
    }
}

