/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.ModulePopupMenu;
import ch.e2e.builder.base.io.E2EFileFilter;
import ch.e2e.builder.base.io.FileService;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.testcase.ViewTestcaseParameterAction;
import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterTransferHandler;
import ch.e2e.io.FileUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JMenuItem;
import javax.swing.TransferHandler;

public class ResponsePopup
extends ModulePopupMenu {
    private E2EBuilderModule module;
    private TestcaseParameter parameter;
    private ParameterTransferHandler transferHandler;
    private JMenuItem copyItem;
    private ViewTestcaseParameterAction viewParameterAction;
    private JMenuItem saveItem;

    public ResponsePopup(E2EBuilderModule module) {
        super(module);
        this.module = module;
        this.transferHandler = new ParameterTransferHandler();
        this.viewParameterAction = new ViewTestcaseParameterAction(module);
        this.addItems();
    }

    public void setParameter(TestcaseParameter parameter) {
        this.parameter = parameter;
        this.transferHandler.setParameter(parameter);
        this.copyItem.setEnabled(!parameter.isNull());
        this.saveItem.setEnabled(parameter.isBlob());
        this.viewParameterAction.setParameter(parameter);
    }

    private void addItems() {
        this.copyItem = ComponentFactory.createMenuItem((String)"popup.testcase.watch.value.copy", (E2EBuilderModule)this.module);
        String text = this.copyItem.getText();
        this.copyItem.setAction(TransferHandler.getCopyAction());
        this.copyItem.setTransferHandler((TransferHandler)this.transferHandler);
        this.copyItem.setText(text);
        this.add(this.copyItem);
        this.saveItem = ComponentFactory.createMenuItem((String)"popup.testcase.watch.value.save", (E2EBuilderModule)this.module);
        this.saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = FileService.saveFile((File)new File("blob"), (E2EFileFilter[])new E2EFileFilter[0], (String)ResponsePopup.this.module.getTranslation("popup.testcase.watch.choose.file.dialog.title", "Select file"), (String)ResponsePopup.this.module.getTranslation("popup.testcase.watch.choose.file.dialog.subtitle", "Select file for saving blob data"), (boolean)false);
                if (file != null) {
                    try {
                        FileUtilities.copy((InputStream)new ByteArrayInputStream((byte[])ResponsePopup.this.parameter.getValue()), (OutputStream)new FileOutputStream(file));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        this.add(this.saveItem);
        JMenuItem showItem = ComponentFactory.createMenuItem((String)"popup.testcase.watch.value.show", (E2EBuilderModule)this.module);
        showItem.setAction(this.viewParameterAction);
        this.add(showItem);
    }
}

