/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.builder.trace.gui.testcase.AbstractXmlCodeEditor;
import ch.e2e.builder.trace.gui.testcase.TabbedView;
import ch.e2e.builder.trace.testcase.LogFile;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class LogFileView
extends JPanel
implements TabbedView {
    private AbstractXmlCodeEditor editor;
    private LogFileReader reader = new LogFileReader();
    private Thread readThread;
    private LogFile logFile;
    private long lastModified;

    public LogFileView() {
        super(new BorderLayout());
        this.editor = AbstractXmlCodeEditor.createEditor(false);
        this.editor.setVirtualSpaceAllowed(false);
        this.editor.setFontSize(this.getFont().getSize());
        this.editor.setEditable(false);
        this.editor.setBackground(Color.WHITE);
        this.add((Component)((Object)this.editor));
    }

    @Override
    public Object getPrintableObject() {
        return this.editor;
    }

    @Override
    public void setTestcase(Testcase testcase) {
        LogFile logFile = this.getLogFile((TestcaseObject)testcase);
        if (!(logFile == null || this.logFile != null && this.logFile.equals((Object)logFile))) {
            this.logFile = logFile;
            this.lastModified = -1L;
            this.editor.setText(null);
        }
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected && this.logFile.getLogFile().lastModified() > this.lastModified) {
            this.lastModified = this.logFile.getLogFile().lastModified();
            if (this.logFile.exists()) {
                this.readLogFile();
            }
        }
    }

    private void readLogFile() {
        if (this.reader.isOpen()) {
            this.reader.close();
        }
        if (this.readThread == null || !this.readThread.isAlive()) {
            this.readThread = new Thread(this.reader);
            this.readThread.start();
        }
    }

    @Override
    public void refresh() {
    }

    @Override
    public void setRoot(Object root) {
    }

    protected abstract LogFile getLogFile(TestcaseObject var1);

    private class LogFileReader
    implements Runnable {
        private FileChannel channel;
        private InputStream inputStream;

        private LogFileReader() {
        }

        @Override
        public void run() {
            final File f = LogFileView.this.logFile.getLogFile();
            LogFileView.this.editor.setText("Reading '" + f.getName() + "' ...");
            LogFileView.this.editor.setOpaque(false);
            Runnable worker = new Runnable(){

                @Override
                public void run() {
                    try {
                        LogFileReader.this.channel = new FileInputStream(f).getChannel();
                        LogFileReader.this.inputStream = Channels.newInputStream(LogFileReader.this.channel);
                        byte[] buffer = new byte[(int)f.length()];
                        BufferedInputStream f2 = new BufferedInputStream(LogFileReader.this.inputStream);
                        f2.read(buffer);
                        LogFileView.this.editor.setText(new String(buffer, "utf-8"));
                    }
                    catch (IOException e) {
                        LogFileView.this.editor.setText("Reading of '" + f.getName() + "' was interrupted");
                    }
                    finally {
                        LogFileView.this.editor.setOpaque(true);
                        if (LogFileReader.this.inputStream != null) {
                            try {
                                LogFileReader.this.inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            };
            SwingUtilities.invokeLater(worker);
        }

        public boolean isOpen() {
            return this.channel != null && this.channel.isOpen();
        }

        public void close() {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

