/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.secure;

import ch.e2e.secure.Logging;
import ch.e2e.secure.TrustQuestion;
import ch.e2e.util.StringTools;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.swing.JOptionPane;

public class DefaultTrustManagerQuestion
implements TrustQuestion,
Logging {
    private String defaultTitle = "Untrusted Certificate";

    @Override
    public int trust(X509Certificate[] chain) {
        String message = this.createDefaultMessage(chain);
        Object[] options = new Object[]{"Continue", "Trust & Continue", "Cancel"};
        int trustResult = JOptionPane.showOptionDialog(null, message, this.defaultTitle, -1, -1, null, options, options[0]);
        switch (trustResult) {
            case 0: {
                trustResult = 100;
                break;
            }
            case 1: {
                trustResult = 101;
                break;
            }
            default: {
                trustResult = 102;
            }
        }
        return trustResult;
    }

    protected String createDefaultMessage(X509Certificate[] chain) {
        StringBuffer message = new StringBuffer();
        message.append("<html><body><table>");
        message.append("<tr><th align=\"left\">Issued To:</th><td>" + chain[0].getIssuerDN().getName() + "</td></tr>");
        message.append("<tr><th align=\"left\">Issued By:</th><td>" + chain[0].getSubjectDN().getName() + "</td></tr>");
        message.append("<tr><th align=\"left\">&nbsp;</th><td>&nbsp;</td></tr>");
        message.append("<tr><th align=\"left\">Serial Number:</th><td>" + StringTools.toHexString(chain[0].getSerialNumber().toByteArray()) + "</td></tr>");
        message.append("<tr><th align=\"left\">&nbsp;</th><td>&nbsp;</td></tr>");
        message.append("<tr><th align=\"left\">Issued On:</th><td>" + chain[0].getNotBefore() + "</td></tr>");
        message.append("<tr><th align=\"left\">Expires On:</th><td>" + chain[0].getNotAfter() + "</td></tr>");
        message.append("<tr><th align=\"left\">&nbsp;</th><td>&nbsp;</td></tr>");
        try {
            message.append("<tr><th align=\"left\">SHA1 Fingerprint:</th><td>" + StringTools.toHexString(MessageDigest.getInstance("SHA1").digest(chain[0].getEncoded())) + "</td></tr>");
            message.append("<tr><th align=\"left\">MD5 Fingerprint:</th><td>" + StringTools.toHexString(MessageDigest.getInstance("MD5").digest(chain[0].getEncoded())) + "</td></tr>");
        }
        catch (NoSuchAlgorithmException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
        }
        catch (CertificateEncodingException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "", e);
        }
        message.append("</table><br></body></html>");
        return message.toString();
    }
}

