/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.logging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogManager {
    public static final String GLOBAL_LOGGER_NAME = "global";
    private static LogManager logManager;

    private LogManager(InputStream properties) {
        this.readConfiguration(properties);
    }

    private LogManager(Properties properties) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            properties.store(out, "");
            this.readConfiguration(new ByteArrayInputStream(out.toByteArray()));
        }
        catch (IOException ioEx) {
            Logger.getLogger(GLOBAL_LOGGER_NAME).severe("Caught a " + ioEx.getClass().getName() + ": " + ioEx.getMessage());
            Logger.getLogger(GLOBAL_LOGGER_NAME).throwing(logManager.getClass().getName(), "<init>", ioEx);
        }
    }

    private LogManager(File loggingProperties) {
        if (loggingProperties.exists()) {
            try {
                this.readConfiguration(new FileInputStream(loggingProperties));
            }
            catch (IOException ioEx) {
                Logger.getLogger(GLOBAL_LOGGER_NAME).severe("Caught a " + ioEx.getClass().getName() + ": " + ioEx.getMessage());
                Logger.getLogger(GLOBAL_LOGGER_NAME).throwing(logManager.getClass().getName(), "<init>", ioEx);
            }
        }
    }

    public static void initialize(File loggingProperties) {
        logManager = new LogManager(loggingProperties);
    }

    public static void initialize(Properties loggingProperties) {
        logManager = new LogManager(loggingProperties);
    }

    public static void initialize(InputStream loggingProperties) {
        logManager = new LogManager(loggingProperties);
    }

    public static LogManager getLogManager() {
        if (logManager == null) {
            logManager = new LogManager(new File("logging.properties"));
        }
        return logManager;
    }

    static String getProperty(String name) {
        String result = java.util.logging.LogManager.getLogManager().getProperty(name);
        return result;
    }

    public static Logger getLogger(String name) {
        Logger logger = java.util.logging.LogManager.getLogManager().getLogger(name);
        if (logger == null) {
            logger = Logger.getLogger(name);
        }
        return logger;
    }

    private void readConfiguration(InputStream ins) {
        try {
            java.util.logging.LogManager.getLogManager().readConfiguration(ins);
        }
        catch (IOException e) {
            Logger.getLogger(GLOBAL_LOGGER_NAME).severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logger.getLogger(GLOBAL_LOGGER_NAME).throwing(this.getClass().getName(), "readConfiguration", e);
        }
    }

    static Level getLevelProperty(String name, Level defaultValue) {
        Level result = defaultValue;
        String val = java.util.logging.LogManager.getLogManager().getProperty(name);
        try {
            if (val != null) {
                result = Level.parse(val.trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

