/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.merge;

import ch.e2e.builder.base.io.UniqueIdService;
import ch.e2e.builder.trace.testcase.SynchronousTestcaseTemplate;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.traceviewer.testcase.SynchronousTestcase;
import ch.e2e.builder.traceviewer.testcase.SynchronousTestcaseRoot;
import ch.e2e.builder.traceviewer.testcase.WSDLFolder;
import ch.e2e.io.FileUtilities;
import ch.e2e.test.E2ETest;
import ch.e2e.test.E2ETestSource;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;

public class RunImportWSDLTestcaseTest
extends E2ETest {
    private static final int BUFSIZE = 1024;
    private static final FilenameFilter filenameFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !"CVS".equals(name);
        }
    };

    public void doTest() throws Exception {
        E2ETestSource testcaseHomeSource = this.getSource("testcaseHome");
        RunImportWSDLTestcaseTest.assertFalse((String)"Element <source name=\"testcaseHome\" value=\"...\" type=\"file\" /> must be defined.", (testcaseHomeSource == null ? 1 : 0) != 0);
        File testcaseHome = (File)testcaseHomeSource.getValue();
        RunImportWSDLTestcaseTest.assertTrue((String)("Testcasehome '" + testcaseHome.getAbsolutePath() + "' does not exists"), (boolean)testcaseHome.exists());
        E2ETestSource outputDirSource = this.getSource("outputDir");
        RunImportWSDLTestcaseTest.assertFalse((String)"Element <source name=\"outputDir\" value=\"...\" type=\"file\" /> must be defined.", (outputDirSource == null ? 1 : 0) != 0);
        File outputDir = new File((File)outputDirSource.getValue(), testcaseHome.getPath());
        if (!outputDir.exists()) {
            RunImportWSDLTestcaseTest.assertTrue((String)("Can't create directory '" + outputDir.getAbsolutePath() + "'."), (boolean)outputDir.mkdirs());
        } else {
            FileUtilities.deleteAll((File)outputDir);
        }
        this.copy(testcaseHome, outputDir);
        testcaseHome = outputDir;
        E2ETestSource operationSource = this.getSource("operation");
        RunImportWSDLTestcaseTest.assertFalse((String)"Element <source name=\"operation\" value=\"...\" type=\"string\" /> must be defined.", (operationSource == null ? 1 : 0) != 0);
        File idFile = new File(testcaseHome, ".synchronous.id");
        RunImportWSDLTestcaseTest.assertTrue((String)("Testcase ID file '" + idFile.getAbsolutePath() + "' does not exists"), (boolean)idFile.exists());
        HashMap ids = UniqueIdService.loadUniqueIds((File)idFile);
        String operation = (String)operationSource.getValue();
        String id = (String)ids.get(operation);
        RunImportWSDLTestcaseTest.assertFalse((String)("ID for operation '" + operation + "' does not exists"), (id == null ? 1 : 0) != 0);
        File operationHome = new File(testcaseHome, id);
        RunImportWSDLTestcaseTest.assertTrue((String)("Operation testcaseHome '" + operationHome.getAbsolutePath() + "' does not exists"), (boolean)operationHome.exists());
        E2ETestSource testcaseSource = this.getSource("testcase");
        RunImportWSDLTestcaseTest.assertFalse((String)"Element <source name=\"testcase\" value=\"...\" type=\"string\" /> must be defined.", (testcaseSource == null ? 1 : 0) != 0);
        File templateFile = new File(operationHome, "template.xml");
        RunImportWSDLTestcaseTest.assertTrue((String)("Template file for operation '" + operation + "' does not exists"), (boolean)templateFile.exists());
        E2ETestSource wsdlFileSource = this.getSource("wsdlFile");
        RunImportWSDLTestcaseTest.assertFalse((String)"Element <source name=\"wsdlFile\" value=\"...\" type=\"file\" /> must be defined.", (wsdlFileSource == null ? 1 : 0) != 0);
        File wsdlFile = (File)wsdlFileSource.getValue();
        RunImportWSDLTestcaseTest.assertTrue((String)("WSDL file '" + wsdlFile.getAbsolutePath() + "' does not exists"), (boolean)wsdlFile.exists());
        SynchronousTestcaseTemplate template = new SynchronousTestcaseTemplate(templateFile);
        SynchronousTestcase testcase = new SynchronousTestcase((String)testcaseSource.getValue(), template, operationHome);
        testcase.clearResult();
        WSDLFolder container = new WSDLFolder(testcaseHome.getName(), testcaseHome);
        new SynchronousTestcaseRoot("ROOT").add((TestcaseObject)container);
    }

    public String getRecommendedCompareType() {
        return "XmlCompare";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copy(File source, File target) throws IOException {
        if (!source.exists()) return;
        if (source.isDirectory()) {
            if (!target.exists() && !target.mkdirs()) {
                throw new IOException("Couldn't create directory '" + target.getAbsolutePath() + "'!");
            }
            if (!target.isDirectory()) throw new IOException("Directory '" + target.getAbsolutePath() + "' doesn't exist!");
            for (File s : source.listFiles(filenameFilter)) {
                this.copy(s, new File(target, s.getName()));
            }
            return;
        }
        File t = target.isDirectory() ? new File(target, source.getName()) : target;
        char[] buf = new char[1024];
        FileReader reader = null;
        OutputStreamWriter writer = null;
        try {
            int len;
            reader = new FileReader(source);
            writer = new FileWriter(t);
            while ((len = reader.read(buf)) > 0) {
                writer.write(buf, 0, len);
            }
            return;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

