/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.ActionParameter;
import ch.e2e.builder.compiler.uml.BridgeClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ActionContext {
    private BridgeClass context;
    private Map<String, ActionParameter> inParameters = new HashMap<String, ActionParameter>();
    private Map<String, ActionParameter> outParameters = new HashMap<String, ActionParameter>();

    public Collection<ActionParameter> getActionParameters() {
        ArrayList<ActionParameter> scriptParameters = new ArrayList<ActionParameter>();
        scriptParameters.addAll(this.inParameters.values());
        scriptParameters.addAll(this.outParameters.values());
        return scriptParameters;
    }

    public Collection<ActionParameter> getIncomingActionParameters() {
        return this.inParameters.values();
    }

    public void addIncomingActionParameter(ActionParameter parameter) {
        String key = parameter.getKey();
        if (key != null) {
            this.inParameters.put(key, parameter);
        }
    }

    public Collection<ActionParameter> getOutgoingActionParameters() {
        return this.outParameters.values();
    }

    public void addOutgoingActionParameter(ActionParameter parameter) {
        String key = parameter.getKey();
        if (key != null) {
            this.outParameters.put(key, parameter);
        }
    }

    public ActionParameter getActionParameter(String name) {
        ActionParameter found = this.inParameters.get(name);
        if (found == null) {
            found = this.outParameters.get(name);
        }
        return found;
    }

    public BridgeClass getContext() {
        return this.context;
    }

    public void setContext(BridgeClass context) {
        this.context = context;
    }
}

