/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.xslt;

import ch.e2e.builder.compiler.document.importer.xslt.XSLTScript;
import ch.e2e.builder.compiler.document.importer.xslt.XSLTScriptObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class XSLTScriptArchive
extends XSLTScriptObject {
    private String[] allScripts;
    private ArrayList<XSLTScript> scripts = new ArrayList();

    public XSLTScriptArchive(File archiveFile) throws IOException {
        super(archiveFile);
        this.fillAllScripts(archiveFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillAllScripts(File archiveFile) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archiveFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            ArrayList<String> scriptNames = new ArrayList<String>();
            while (entries.hasMoreElements()) {
                scriptNames.add(entries.nextElement().getName());
            }
            this.allScripts = new String[scriptNames.size()];
            scriptNames.toArray(this.allScripts);
            Arrays.sort(this.allScripts);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void addScript(String name) {
        this.scripts.add(new XSLTScript(name));
    }

    public ArrayList<XSLTScript> getScripts() {
        return this.scripts;
    }

    public String[] getAllScripts() {
        return this.allScripts;
    }
}

