/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.java;

public class ClassPoolEntry {
    int ptr1;
    int ptr2;
    String value;
    int tagByte;

    public ClassPoolEntry(int tagByte, String value, int ptr1, int ptr2) {
        this.tagByte = tagByte;
        this.value = value;
        this.ptr1 = ptr1;
        this.ptr2 = ptr2;
    }

    public int getPtr1() {
        return this.ptr1;
    }

    public int getPtr2() {
        return this.ptr2;
    }

    public String getValue() {
        return this.value;
    }

    public int getTagByte() {
        return this.tagByte;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getTagName(this.tagByte));
        sb.append(",");
        if (this.ptr1 == -1) {
            sb.append(" - ");
        } else {
            sb.append(this.ptr1);
        }
        sb.append(",");
        if (this.ptr2 == -1) {
            sb.append(" - ");
        } else {
            sb.append(this.ptr2);
        }
        sb.append(",");
        if (this.tagByte == 1) {
            sb.append(this.value);
        } else {
            sb.append(" - ");
        }
        return sb.toString();
    }

    private String getTagName(int tagByte) {
        switch (tagByte) {
            case 1: {
                return "TAG_UTF8";
            }
            case 3: {
                return "TAG_INTEGER";
            }
            case 4: {
                return "TAG_FLOAT";
            }
            case 5: {
                return "TAG_LONG";
            }
            case 6: {
                return "TAG_DOUBLE";
            }
            case 7: {
                return "TAG_CLASS";
            }
            case 8: {
                return "TAG_STRING";
            }
            case 9: {
                return "TAG_FIELDREF";
            }
            case 10: {
                return "TAG_METHODREF";
            }
            case 11: {
                return "TAG_INTERFACEREF";
            }
            case 12: {
                return "TAG_NAMETYPE";
            }
            case -1: {
                return "TAG_NOTHING";
            }
        }
        return "Invalid Tag";
    }
}

