/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.java;

import ch.e2e.builder.compiler.document.importer.java.ClassPoolEntry;
import ch.e2e.builder.compiler.document.importer.java.ImportList;
import ch.e2e.builder.compiler.document.importer.java.ParserConstants;
import java.util.ArrayList;
import java.util.List;

public class ClassPool
implements ParserConstants {
    public static final String STR_INVALID = "Invalid String";
    public static final int PTR_INVALID = -1;
    public static final int TAG_NOTHING = -1;
    public static final int TAG_UTF8 = 1;
    public static final int TAG_INTEGER = 3;
    public static final int TAG_FLOAT = 4;
    public static final int TAG_LONG = 5;
    public static final int TAG_DOUBLE = 6;
    public static final int TAG_CLASS = 7;
    public static final int TAG_STRING = 8;
    public static final int TAG_FIELDREF = 9;
    public static final int TAG_METHODREF = 10;
    public static final int TAG_INTERFACEREF = 11;
    public static final int TAG_NAMETYPE = 12;
    private List listEntries;
    private ImportList importedClasses;

    public ClassPool(int cpMax) {
        this.listEntries = new ArrayList(cpMax);
        this.importedClasses = null;
    }

    public int getMaxCpEntry() {
        return this.listEntries.size();
    }

    public List getEntries() {
        return this.listEntries;
    }

    public void addFieldRefEntry(int ptr1, int ptr2) {
        this.listEntries.add(new ClassPoolEntry(9, STR_INVALID, ptr1, ptr2));
    }

    public void addMethodRefEntry(int ptr1, int ptr2) {
        this.listEntries.add(new ClassPoolEntry(10, STR_INVALID, ptr1, ptr2));
    }

    public void addInterfaceRefEntry(int ptr1, int ptr2) {
        this.listEntries.add(new ClassPoolEntry(11, STR_INVALID, ptr1, ptr2));
    }

    public void addNameTypeEntry(int ptr1, int ptr2) {
        this.listEntries.add(new ClassPoolEntry(12, STR_INVALID, ptr1, ptr2));
    }

    public void addNullEntry() {
        this.listEntries.add(new ClassPoolEntry(-1, STR_INVALID, -1, -1));
    }

    public void addUtf8Entry(String value) {
        this.listEntries.add(new ClassPoolEntry(1, value, -1, -1));
    }

    public void addIntegerEntry(String value) {
        this.listEntries.add(new ClassPoolEntry(3, value, -1, -1));
    }

    public void addFloatEntry(String value) {
        this.listEntries.add(new ClassPoolEntry(4, value, -1, -1));
    }

    public void addDoubleEntry(String value) {
        this.listEntries.add(new ClassPoolEntry(6, value, -1, -1));
    }

    public void addLongEntry(String value) {
        this.listEntries.add(new ClassPoolEntry(5, value, -1, -1));
    }

    public void addClassEntry(int classIndex) {
        this.listEntries.add(new ClassPoolEntry(7, STR_INVALID, classIndex, -1));
    }

    public void addStringEntry(int stringIndex) {
        this.listEntries.add(new ClassPoolEntry(8, STR_INVALID, stringIndex, -1));
    }

    private String getFirstDirectName(int index) {
        int ptr1 = ((ClassPoolEntry)this.listEntries.get(index)).getPtr1();
        return ((ClassPoolEntry)this.listEntries.get(ptr1)).getValue();
    }

    public ImportList getImportedClasses() {
        if (this.importedClasses != null) {
            return this.importedClasses;
        }
        this.importedClasses = new ImportList();
        block5: for (int i = 0; i < this.listEntries.size(); ++i) {
            ClassPoolEntry ent = (ClassPoolEntry)this.listEntries.get(i);
            switch (ent.getTagByte()) {
                case 7: {
                    String datatype = this.getJavaDataType(this.getFirstDirectName(i));
                    this.importedClasses.addClass(datatype);
                    continue block5;
                }
                case 9: {
                    String type = this.getType(ent);
                    this.importedClasses.addClass(this.getJavaDataType(type));
                    continue block5;
                }
                case 10: 
                case 11: {
                    String methodType = this.getType(ent);
                    List args = this.getArguments(methodType);
                    for (int j = 0; j < args.size(); ++j) {
                        String argtype = (String)args.get(j);
                        this.importedClasses.addClass(this.getJavaDataType(argtype));
                    }
                    this.importedClasses.addClass(this.getJavaDataType(this.getReturnType(methodType)));
                }
            }
        }
        return this.importedClasses;
    }

    private String getType(ClassPoolEntry ent) {
        ClassPoolEntry entNameType = (ClassPoolEntry)this.listEntries.get(ent.getPtr2());
        ClassPoolEntry entType = (ClassPoolEntry)this.listEntries.get(entNameType.getPtr2());
        return entType.getValue();
    }

    public String getJavaDataType(String datatype) {
        String result = datatype;
        char firstChar = datatype.charAt(0);
        if (datatype.length() == 1) {
            switch (firstChar) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    result = null;
                }
            }
        } else if (firstChar == '[') {
            result = this.getJavaDataType(datatype.substring(1));
        } else if (firstChar == 'L') {
            if (datatype.indexOf(";") == -1) {
                result = datatype.substring(1);
            } else {
                int length = datatype.length();
                result = datatype.substring(1, length - 1);
            }
        }
        return result;
    }

    private String getReturnType(String signature) {
        int index = signature.indexOf(")");
        return signature.substring(index + 1);
    }

    private List getArguments(String signature) {
        ArrayList<String> args = new ArrayList<String>();
        int endIndex = signature.indexOf(")");
        if (endIndex != 1) {
            int tokenLength;
            String origStr = signature = signature.substring(1, endIndex);
            int length = origStr.length();
            for (int curIndex = 0; curIndex < length; curIndex += tokenLength) {
                signature = origStr.substring(curIndex);
                String tokenString = signature.substring(0, tokenLength = this.getSignTokenLength(signature));
                int semiColon = tokenString.indexOf(";");
                if (semiColon != -1) {
                    tokenString = tokenString.substring(0, semiColon);
                }
                args.add(tokenString);
            }
        }
        return args;
    }

    private int getSignTokenLength(String datatype) {
        char ch = datatype.charAt(0);
        switch (ch) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return 1;
            }
            case '[': {
                return this.getSignTokenLength(datatype.substring(1)) + 1;
            }
            case 'L': {
                int semiColon = datatype.indexOf(";");
                if (semiColon == -1) {
                    return datatype.length();
                }
                return semiColon + 1;
            }
        }
        return 0;
    }
}

