/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.addons.rest;

import ch.e2e.builder.compiler.build.types.addons.rest.RelativeURI;
import ch.e2e.builder.compiler.build.types.addons.rest.Request;
import ch.e2e.builder.compiler.build.types.addons.rest.Responses;
import ch.e2e.builder.compiler.build.types.tabfile.RichElement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class Resource
extends RichElement {
    public static final String ELEMENT_NAME = "Resource";
    private RelativeURI relativeURI;
    private Responses responses;
    private Map<String, Request> requests = new LinkedHashMap<String, Request>();
    private Map<RelativeURI, Resource> resources = new LinkedHashMap<RelativeURI, Resource>();

    public Resource(Element tabfileElement) {
        super(tabfileElement);
        this.relativeURI = this.createFrom(tabfileElement, "RelativeURI", RelativeURI.class);
        this.responses = this.createFrom(tabfileElement, "Responses", Responses.class);
        Iterator<Element> requestIterator = Resource.getElementIteratorByXPath(tabfileElement, "Request");
        while (requestIterator.hasNext()) {
            this.addRequest(requestIterator.next());
        }
        Iterator<Element> resourceIterator = Resource.getElementIteratorByXPath(tabfileElement, ELEMENT_NAME);
        while (resourceIterator.hasNext()) {
            this.addResource(resourceIterator.next());
        }
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    public void addRequest(Element tabfileElement) {
        Request request = new Request(tabfileElement);
        this.requests.put(request.getName(), request);
    }

    public void addResource(Element tabfileElement) {
        Resource resource = new Resource(tabfileElement);
        this.resources.putIfAbsent(resource.relativeURI, resource);
    }

    @Override
    protected void prepareChildren() {
        if (this.relativeURI != null && this.relativeURI.hasSegments()) {
            this.appendChild(this.relativeURI);
        }
        this.appendChildren(this.responses);
        this.appendChildren(this.requests.values());
        this.appendChildren(this.resources.values());
    }

    public void mergeIn(Resource definition) {
        if (this.responses != null) {
            if (definition.responses != null) {
                this.responses.mergeIn(definition.responses);
            }
        } else {
            this.responses = definition.responses;
        }
        this.requests.putAll(definition.requests);
        for (Resource resource : definition.resources.values()) {
            if (this.resources.containsKey(resource.relativeURI)) {
                this.resources.get(resource.relativeURI).mergeIn(resource);
                continue;
            }
            this.resources.put(resource.relativeURI, resource);
        }
    }
}

