/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.io.FileUtilities;
import ch.e2e.util.VersionChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class WrapperJarfileMerger {
    private ArrayList<File> wrapperJarfiles = new ArrayList();
    private File addonJarfile;
    private String addonVersion;

    public void addWrapperJar(File wrapperJar) {
        this.wrapperJarfiles.add(wrapperJar);
    }

    public void addMergedWrapperJarfile(ZipOutputStream out, ArrayList<String> existingEntries) throws IOException {
        if (this.wrapperJarfiles.size() > 0) {
            File completeWrapperJar = File.createTempFile("wrapper.jar", "complete");
            ArrayList<String> completeEntries = new ArrayList<String>();
            ZipOutputStream completeOut = new ZipOutputStream(new FileOutputStream(completeWrapperJar));
            for (File file : this.wrapperJarfiles) {
                ZipFile wrapperJar = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = wrapperJar.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry next = entries.nextElement();
                    if (completeEntries.contains(next.getName())) continue;
                    completeEntries.add(next.getName());
                    completeOut.putNextEntry(next);
                    if (!next.isDirectory()) {
                        FileUtilities.copy((InputStream)wrapperJar.getInputStream(next), (OutputStream)completeOut, (boolean)false);
                    }
                    completeOut.closeEntry();
                }
            }
            completeOut.flush();
            completeOut.close();
            ZipEntry wrapperEntry = new ZipEntry("java/lib/wrapper.jar");
            out.putNextEntry(wrapperEntry);
            FileUtilities.copy((InputStream)new FileInputStream(completeWrapperJar), (OutputStream)out, (boolean)false);
            out.closeEntry();
            existingEntries.add(wrapperEntry.getName());
            completeWrapperJar.delete();
        }
    }

    public void addAddOnJar(File addOnPath) throws IOException {
        String incomingVersion;
        if (null != this.addonJarfile) {
            if (this.addonJarfile.getCanonicalPath().compareTo(addOnPath.getCanonicalPath()) == 0) {
                return;
            }
            incomingVersion = this.readVersion(addOnPath);
            if (null == incomingVersion || incomingVersion.equals(this.addonVersion)) {
                return;
            }
            if (this.addonVersion != null && !VersionChecker.isNewer((String)this.addonVersion, (String)incomingVersion)) {
                return;
            }
        } else {
            incomingVersion = this.readVersion(addOnPath);
        }
        this.addonJarfile = addOnPath;
        this.addonVersion = incomingVersion;
    }

    private String readVersion(File addOnPath) throws IOException {
        JarFile addonJar = new JarFile(addOnPath);
        Manifest addonManifest = addonJar.getManifest();
        return addonManifest.getMainAttributes().getValue("Module-Version");
    }

    public void addAddOnJarfile(ZipOutputStream out, ArrayList<String> existingEntries) throws IOException {
        if (null != this.addonJarfile) {
            ZipEntry entry = new ZipEntry("java/lib/addon.jar");
            out.putNextEntry(entry);
            FileUtilities.copy((InputStream)new FileInputStream(this.addonJarfile), (OutputStream)out, (boolean)false);
            out.closeEntry();
            existingEntries.add(entry.getName());
        }
    }
}

