/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi.libraries.form;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.utils.JaxbUtils;
import ch.e2e.builder.compiler.document.JsonDocument;
import ch.e2e.builder.compiler.document.json.library.LibraryForm;
import ch.e2e.builder.compiler.document.json.xuml.form.XumlForm;
import ch.e2e.builder.compiler.document.json.xuml.form.XumlFormElementChild;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class LibraryFormTask
extends CacheAbleTask
implements JsonDocumentSource {
    private LibraryForm jsonDocument;
    private XumlForm xumlForm;

    public static Boolean select(String id) {
        return !id.startsWith(Folders.libs_) && id.endsWith(Extensions._library_form_json);
    }

    public LibraryFormTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getSourceId());
        return result;
    }

    private String getLibraryFormJsonSource(XumlFormElementChild xumlFormElementChild) {
        String form = xumlFormElementChild.getForm();
        if (form.contains(Extensions._library_json + "#")) {
            return form.substring(0, form.indexOf(Extensions._library_json + "#")) + Folders.SEPARATOR + Folders.forms_ + form.substring(form.indexOf("#form:") + 6) + Extensions._library_form_json;
        }
        return form + Extensions._library_form_json;
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        this.getXumlForm().getFormElements().stream().filter(xumlFormElement -> xumlFormElement instanceof XumlFormElementChild).forEach(xumlFormElement -> result.add(this.getLibraryFormJsonSource((XumlFormElementChild)xumlFormElement)));
        return result;
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._library_form_json;
    }

    private String getSourceId() {
        return this.getDestinationFilePathWithoutExtension() + Extensions._form_xml;
    }

    private XumlForm getXumlForm() {
        if (this.xumlForm == null) {
            JsonDocumentSource source = (JsonDocumentSource)this.getSourceManager().getSource(this.getSourceId());
            this.xumlForm = source.getJsonDocument(XumlForm.class);
        }
        return this.xumlForm;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            this.jsonDocument = new LibraryForm();
            this.jsonDocument.setName(this.getXumlForm().getName());
            this.jsonDocument.setComponent(this.getXumlForm().getName() + "FormComponent");
            this.jsonDocument.setClass_("urn:Data_Model.Forms." + this.getXumlForm().getName());
            HashSet formEvents = new HashSet();
            if (this.getXumlForm().getFormElements() != null) {
                this.getXumlForm().getFormElements().forEach(xumlFormElement -> {
                    if (xumlFormElement.getEvents() != null) {
                        xumlFormElement.getEvents().forEach(xumlFormEvent -> formEvents.add(xumlFormElement.getName() + "." + xumlFormEvent.getName()));
                    }
                    if (xumlFormElement instanceof XumlFormElementChild) {
                        JsonDocumentSource source = (JsonDocumentSource)this.getSourceManager().getSource(this.getLibraryFormJsonSource((XumlFormElementChild)xumlFormElement));
                        source.getJsonDocument(LibraryForm.class).getFormEvents().forEach(formEvent -> formEvents.add(xumlFormElement.getName() + "." + formEvent));
                    }
                });
            }
            this.jsonDocument.setFormEvents(new ArrayList<String>(formEvents));
            JaxbUtils.marshallJson(this.jsonDocument, this.getDestinationFile());
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    @Override
    public <T extends JsonDocument> T getJsonDocument(Class<T> type) {
        if (this.jsonDocument == null) {
            if (!this.isExecuted()) {
                this.execute();
            }
            if (this.isUpToDate()) {
                try {
                    this.jsonDocument = JaxbUtils.unmarshallJson(this.getDestinationFile(), LibraryForm.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return (T)this.jsonDocument;
    }
}

