/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi;

import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.XSLTTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.model.libraries.LibraryIdlMapTask;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.callbacks.SearchCallbackImplementationsTask;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.model.AliasesXmiTransformationModelTask;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.testables.SearchTestablesTask;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.LibraryIdlMapSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.TaskFactory;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import com.scheer.pas.compiler.xuml.api.tasks.repositories.RepositoryItemTypeService;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ComponentModelTask
extends XSLTTask {
    private final RepositoryItemTypeService repositoryItemTypeService;

    public ComponentModelTask(SourceManager sourceManager, String id, RepositoryItemTypeService repositoryItemTypeService) {
        super(sourceManager, id);
        this.repositoryItemTypeService = repositoryItemTypeService;
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._xml;
    }

    @Override
    protected String getTransformerId() {
        return "model.xmi.component";
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(Files.project_xml);
        result.add(LibraryIdlMapTask.LibraryIdlMapTask_ID);
        result.addAll(AliasesXmiTransformationModelTask.getAliasesSourceSet(this.getSourceManager()));
        return result;
    }

    private LibraryIdlMapSource getLibraryIdlMapSource() {
        return (LibraryIdlMapSource)this.getSource(LibraryIdlMapTask.LibraryIdlMapTask_ID);
    }

    private Set<String> getLibrariesComponentsSourceSet() {
        return this.getLibraryIdlMapSource().getLibraryIdlMap().getMap().keySet().stream().map(Files::libs_LIBRARY__LIBRARY_library_components_xml).collect(Collectors.toSet());
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(Files.project_xml);
        result.addAll(this.getLibrariesComponentsSourceSet());
        result.addAll(AliasesXmiTransformationModelTask.getXumlAliasesSourceSet(this.getSourceManager()));
        XumlProject projectDocument = ((JsonDocumentSource)this.getSourceManager().getSource(Files.project_xml)).getJsonDocument(XumlProject.class);
        result.add(Folders.model_ + projectDocument.getName() + Extensions._bpmn_components_xml);
        File[] apiFolderContent = new File(this.getSourceManager().getProjectFolder(), Folders.api).listFiles();
        if (apiFolderContent != null) {
            Arrays.stream(apiFolderContent).filter(file -> file.getName().endsWith(Extensions._api_json)).map(file -> file.getName().replace(Extensions._api_json, "")).forEach(apiName -> result.add(Files.api__APINAME__APINAME_components_xml(apiName)));
        }
        result.add(SearchCallbackImplementationsTask.SearchCallbackImplementationsTask_ID);
        result.add(SearchTestablesTask.SearchTestablesTask_ID);
        this.repositoryItemTypeService.getItemTypes().forEach(itemType -> result.addAll(itemType.getComponentModelTaskSourceSet(this.sourceManager)));
        return result;
    }

    @Override
    protected Map<String, Object> getTransformParameters() {
        Map<String, Object> map = super.getTransformParameters();
        map.put("isUI", true);
        return map;
    }

    public static class Factory
    extends TaskFactory {
        RepositoryItemTypeService repositoryItemTypeService;

        public Factory(RepositoryItemTypeService repositoryItemTypeService, Double priority) {
            super(priority);
            this.repositoryItemTypeService = repositoryItemTypeService;
        }

        @Override
        public Boolean matchId(String id) {
            return id.endsWith(Extensions._xmiTransformationModel_xml);
        }

        @Override
        public CacheAbleTask createTask(String id, SourceManager sourceManager) {
            return new ComponentModelTask(sourceManager, id, this.repositoryItemTypeService);
        }
    }
}

