/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.libraries;

import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.model.libraries.LibrariesHelper;
import ch.e2e.builder.compiler.build.tasks.model.libraries.LibraryIdlMapTask;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.IDL2XmiTransformationModelTask;
import ch.e2e.builder.compiler.build.tasks.source.LibraryIdlMapSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.importer.IDLImportSource;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class LibraryIdl2XmiTransformationModelTask
extends IDL2XmiTransformationModelTask {
    public static Boolean select(String id) {
        return id.endsWith(Extensions._import_component_xmiTransformationModel_xml);
    }

    public LibraryIdl2XmiTransformationModelTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        Set<String> result = super.getBeforeSourceSet();
        result.add(LibraryIdlMapTask.LibraryIdlMapTask_ID);
        return result;
    }

    @Override
    protected List<String> getImportedIdlSourcesIds() {
        HashSet<String> importedNames = new HashSet<String>(LibrariesHelper.getCompilerLibrariesNameSet());
        for (IDLImportSource imported : this.getIDLImportSource().getImportedElements()) {
            importedNames.add(imported.getName());
        }
        return importedNames.stream().map(name -> LibraryIdlMapSource.getLibraryIdlSourceId(name, this.getLibraryIdlMapSource())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._import_component_xmiTransformationModel_xml;
    }

    @Override
    protected String getIDLSourceId() {
        return LibraryIdlMapSource.getLibraryIdlSourceId(this.getLibraryName(), this.getLibraryIdlMapSource());
    }

    private String getLibraryName() {
        return this.getDestinationFileNameWithoutExtension();
    }

    private LibraryIdlMapSource getLibraryIdlMapSource() {
        return (LibraryIdlMapSource)this.getSourceManager().getSource(LibraryIdlMapTask.LibraryIdlMapTask_ID);
    }
}

