/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.libraries;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.model.libraries.JsonIdlImportSource;
import ch.e2e.builder.compiler.build.tasks.source.IDLSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.uml.UmlHelper;
import ch.e2e.builder.compiler.document.importer.IDLImportSource;
import ch.e2e.builder.compiler.document.json.idl.Idl;
import ch.e2e.builder.compiler.uml.Helpers;
import java.util.HashSet;
import java.util.Set;

public class Library2JsonIdlTask
extends CacheAbleTask
implements IDLSource {
    private Idl idl;
    private IDLImportSource idlImportSource;

    public static Boolean select(String id) {
        return id.endsWith(Extensions._library_idl_json);
    }

    public Library2JsonIdlTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(Files.libs__LIBRARY_library_zip_file_list(this.getDestinationFileNameWithoutExtension()));
        return result;
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._library_idl_json;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            this.idl = JsonIdlImportSource.getIdl(this.getDestinationFile());
            this.idlImportSource = new JsonIdlImportSource(this.getDestinationFileNameWithoutExtension(), this.idl, UmlHelper.getWorkUmlImportsFolder(this.getSourceManager().getWorkFolder()), new Helpers());
            this.idlImportSource.getImportModel().setCreate(true);
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    @Override
    public IDLImportSource getIDLImportSource() {
        if (this.idlImportSource == null) {
            if (this.idl == null && this.isUpToDate()) {
                try {
                    this.idl = JsonIdlImportSource.getIdl(this.getDestinationFile());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.idl != null) {
                this.idlImportSource = new JsonIdlImportSource(this.getDestinationFileNameWithoutExtension(), this.idl, UmlHelper.getWorkUmlImportsFolder(this.getSourceManager().getWorkFolder()), new Helpers());
                this.idlImportSource.getImportModel().setCreate(true);
            }
        }
        return this.idlImportSource;
    }
}

