/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.compiler.build.BuildErrorException;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CompileConfigurationTask;
import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.build.types.AsynchronousTraceInformation;
import ch.e2e.builder.compiler.build.types.XPathReplacer;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.io.ZipUtilities;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CreateAsynchronousTraceTask
extends CompileConfigurationTask {
    private static final String COMPILER_ID = "asynchronousTrace";

    public CreateAsynchronousTraceTask() {
        super(new CompileControl[0]);
    }

    @Override
    public void executeTask(int dependencyLevel) throws BuildException {
        try {
            AsynchronousTraceInformation traceInformation = new AsynchronousTraceInformation(this.getUmlDocument());
            for (CompilableObject compilableObject : this.getCompilableObjects()) {
                Document traceInformationDocument = traceInformation.createAsynchronousTraceInformation();
                for (LibraryService library : compilableObject.getLibraries()) {
                    Document traceDocument = ZipUtilities.getZippedDocumentFromFile((File)library.getRepository(), (String)"asynchronous.trace");
                    if (traceDocument == null) continue;
                    NodeList children = traceDocument.getDocumentElement().getChildNodes();
                    int length = children.getLength();
                    for (int i = 0; i < length; ++i) {
                        Node child = children.item(i);
                        if (!(child instanceof Element)) continue;
                        child = traceInformationDocument.importNode(child, true);
                        traceInformationDocument.getDocumentElement().appendChild(child);
                    }
                }
                if (!traceInformationDocument.getDocumentElement().hasChildNodes()) continue;
                File workingFolder = this.getUmlDocument().getDocumentWorkingFolder();
                File descriptorFolder = new File(workingFolder, "descriptor");
                for (Deployment deployment : compilableObject.getDeployments()) {
                    Element configElement = this.getConfigurationElement(deployment, compilableObject.getName(), descriptorFolder);
                    traceInformationDocument.getDocumentElement().setAttribute("host", configElement.getAttribute("host"));
                    traceInformationDocument.getDocumentElement().setAttribute("controlPort", configElement.getAttribute("control"));
                    XPathReplacer.replaceXPathExpressions(traceInformationDocument, configElement, compilableObject, this.getErrorHandler());
                    deployment.readStatesClasses(traceInformationDocument);
                    File traceFile = new File(workingFolder, deployment.getName() + ".asynchronous.trace");
                    this.printDocument(traceInformationDocument, traceFile);
                }
            }
        }
        catch (BuildException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BuildException(ex);
        }
        if (this.getErrorHandler().getErrorCount() > 0) {
            throw new BuildErrorException(COMPILER_ID);
        }
    }

    @Override
    protected String getCompilerId() {
        return COMPILER_ID;
    }
}

