/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms;

import ch.e2e.bridge.server.jms.JMSLogger;
import java.util.Hashtable;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;

public class JMSInitialContext {
    private InitialContext initialContext;
    private Hashtable<?, ?> environment;

    public JMSInitialContext(Hashtable<?, ?> environment) throws NamingException {
        this.environment = environment;
        this.initialContext = new InitialContext(environment);
    }

    public Object lookup(String name) throws NamingException {
        Object result;
        try {
            result = this.initialContext.lookup(name);
        }
        catch (CommunicationException e) {
            this.initialContext.close();
            JMSLogger.getInstance().warning("13", "JNDI communication lost, trying to reinitialize.");
            this.initialContext = new InitialContext(this.environment);
            result = this.initialContext.lookup(name);
        }
        return result;
    }

    public Object lookup(Name name) throws NamingException {
        Object result;
        try {
            result = this.initialContext.lookup(name);
        }
        catch (CommunicationException e) {
            this.initialContext = new InitialContext(this.environment);
            result = this.initialContext.lookup(name);
        }
        return result;
    }

    public void close() throws NamingException {
        if (this.initialContext != null) {
            this.initialContext.close();
        }
    }
}

