/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.ide.VAJProjectDescription;
import org.apache.tools.ant.taskdefs.optional.ide.VAJUtil;

class VAJRemoteUtil
implements VAJUtil {
    Task caller;
    String remoteServer;

    public VAJRemoteUtil(Task caller, String remote) {
        this.caller = caller;
        this.remoteServer = remote;
    }

    public void exportPackages(File destDir, String[] includePatterns, String[] excludePatterns, boolean exportClasses, boolean exportDebugInfo, boolean exportResources, boolean exportSources, boolean useDefaultExcludes, boolean overwrite) {
        try {
            String request = "http://" + this.remoteServer + "/servlet/vajexport?" + "deb" + "=" + exportDebugInfo + "&" + "owr" + "=" + overwrite + "&" + this.assembleImportExportParams(destDir, includePatterns, excludePatterns, exportClasses, exportResources, exportSources, useDefaultExcludes);
            this.sendRequest(request);
        }
        catch (Exception ex) {
            throw new BuildException(ex);
        }
    }

    public void importFiles(String importProject, File srcDir, String[] includePatterns, String[] excludePatterns, boolean importClasses, boolean importResources, boolean importSources, boolean useDefaultExcludes) {
        try {
            String request = "http://" + this.remoteServer + "/servlet/vajimport?" + "project" + "=" + importProject + "&" + this.assembleImportExportParams(srcDir, includePatterns, excludePatterns, importClasses, importResources, importSources, useDefaultExcludes);
            this.sendRequest(request);
        }
        catch (Exception ex) {
            throw new BuildException(ex);
        }
    }

    private String assembleImportExportParams(File dir, String[] includePatterns, String[] excludePatterns, boolean includeClasses, boolean includeResources, boolean includeSources, boolean useDefaultExcludes) {
        int i;
        String result = "dir=" + URLEncoder.encode(dir.getPath()) + "&" + "cls" + "=" + includeClasses + "&" + "res" + "=" + includeResources + "&" + "src" + "=" + includeSources + "&" + "dex" + "=" + useDefaultExcludes;
        if (includePatterns != null) {
            i = 0;
            while (i < includePatterns.length) {
                result = result + "&" + "include" + "=" + URLEncoder.encode(includePatterns[i]);
                ++i;
            }
        }
        if (excludePatterns != null) {
            i = 0;
            while (i < excludePatterns.length) {
                result = result + "&" + "exclude" + "=" + URLEncoder.encode(excludePatterns[i]);
                ++i;
            }
        }
        return result;
    }

    public void loadProjects(Vector projectDescriptions) {
        try {
            String request = "http://" + this.remoteServer + "/servlet/vajload?";
            String delimiter = "";
            Enumeration e = projectDescriptions.elements();
            while (e.hasMoreElements()) {
                VAJProjectDescription pd = (VAJProjectDescription)e.nextElement();
                request = request + delimiter + "project" + "=" + pd.getName().replace(' ', '+') + "&" + "version" + "=" + pd.getVersion().replace(' ', '+');
                delimiter = "&";
            }
            this.sendRequest(request);
        }
        catch (Exception ex) {
            throw new BuildException(ex);
        }
    }

    public void log(String msg, int level) {
        this.caller.log(msg, level);
    }

    private void sendRequest(String request) {
        boolean requestFailed = false;
        try {
            this.log("Request: " + request, 4);
            URL requestUrl = new URL(request);
            HttpURLConnection connection = (HttpURLConnection)requestUrl.openConnection();
            InputStream is = null;
            int i = 0;
            while (i < 3) {
                try {
                    is = connection.getInputStream();
                    break;
                }
                catch (IOException ex) {
                    ++i;
                }
            }
            if (is == null) {
                this.log("Can't get " + request, 0);
                throw new BuildException("Couldn't execute " + request);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = br.readLine();
            while (line != null) {
                int level = 0;
                try {
                    level = Integer.parseInt(line.substring(0, 1));
                    if (level == 0) {
                        requestFailed = true;
                    }
                }
                catch (Exception e) {
                    this.log("Response line doesn't contain log level!", 0);
                }
                this.log(line.substring(2), level);
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            this.log("Error sending tool request to VAJ" + ex, 0);
            throw new BuildException("Couldn't execute " + request);
        }
        if (requestFailed) {
            throw new BuildException("VAJ tool request failed");
        }
    }
}

