/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Properties;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class IContract
extends MatchingTask {
    private static final String ICONTROL_PROPERTIES_HEADER = "You might want to set classRoot to point to your normal compilation class root directory.";
    private String icCompiler = "javac";
    private File targets = null;
    private boolean dirty = false;
    private boolean iContractMissing = false;
    private File srcDir = null;
    private File instrumentDir = null;
    private File buildDir = null;
    private File repositoryDir = null;
    private File repBuildDir = null;
    private Path classpath = null;
    private String failThrowable = "java.lang.Error";
    private String verbosity = "error*";
    private boolean quiet = false;
    private File controlFile = null;
    private boolean pre = true;
    private boolean preModified = false;
    private boolean post = true;
    private boolean postModified = false;
    private boolean invariant = true;
    private boolean invariantModified = false;
    private boolean instrumentall = false;
    private boolean updateIcontrol = false;
    private File classDir = null;

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setClassdir(File classDir) {
        this.classDir = classDir;
    }

    public void setInstrumentdir(File instrumentDir) {
        this.instrumentDir = instrumentDir;
        if (this.buildDir == null) {
            this.setBuilddir(instrumentDir);
        }
    }

    public void setBuilddir(File buildDir) {
        this.buildDir = buildDir;
    }

    public void setRepositorydir(File repositoryDir) {
        this.repositoryDir = repositoryDir;
        if (this.repBuildDir == null) {
            this.setRepbuilddir(repositoryDir);
        }
    }

    public void setRepbuilddir(File repBuildDir) {
        this.repBuildDir = repBuildDir;
    }

    public void setPre(boolean pre) {
        this.pre = pre;
        this.preModified = true;
    }

    public void setPost(boolean post) {
        this.post = post;
        this.postModified = true;
    }

    public void setInvariant(boolean invariant) {
        this.invariant = invariant;
        this.invariantModified = true;
    }

    public void setFailthrowable(String clazz) {
        this.failThrowable = clazz;
    }

    public void setVerbosity(String verbosity) {
        this.verbosity = verbosity;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setTargets(File targets) {
        this.targets = targets;
    }

    public void setControlfile(File controlFile) {
        if (!controlFile.exists()) {
            this.log("WARNING: Control file " + controlFile.getAbsolutePath() + " doesn't exist. iContract will be run " + "without control file.");
        }
        this.controlFile = controlFile;
    }

    public void setClasspath(Path path) {
        this.createClasspath().append(path);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath;
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setUpdateicontrol(boolean updateIcontrol) {
        this.updateIcontrol = updateIcontrol;
    }

    public void execute() throws BuildException {
        this.preconditions();
        this.scan();
        if (this.dirty) {
            int result;
            boolean useControlFile;
            boolean bl = useControlFile = this.controlFile != null && this.controlFile.exists();
            if (useControlFile && !this.preModified) {
                this.pre = false;
            }
            if (useControlFile && !this.postModified) {
                this.post = false;
            }
            if (useControlFile && !this.invariantModified) {
                this.invariant = false;
            }
            if ((this.pre || this.post || this.invariant) && this.controlFile != null) {
                this.log("WARNING: specifying pre,post or invariant will override control file settings");
            }
            this.getProject().addBuildListener(new IContractPresenceDetector());
            Mkdir mkdir = (Mkdir)this.getProject().createTask("mkdir");
            mkdir.setDir(this.instrumentDir);
            mkdir.execute();
            mkdir.setDir(this.buildDir);
            mkdir.execute();
            mkdir.setDir(this.repositoryDir);
            mkdir.execute();
            Path baseClasspath = this.createClasspath();
            String compiler = this.getProject().getProperty("build.compiler");
            ClasspathHelper classpathHelper = new ClasspathHelper(compiler);
            classpathHelper.modify(baseClasspath);
            Path beforeInstrumentationClasspath = (Path)baseClasspath.clone();
            beforeInstrumentationClasspath.append(new Path(this.getProject(), this.srcDir.getAbsolutePath()));
            Path afterInstrumentationClasspath = (Path)baseClasspath.clone();
            afterInstrumentationClasspath.append(new Path(this.getProject(), this.instrumentDir.getAbsolutePath()));
            afterInstrumentationClasspath.append(new Path(this.getProject(), this.repositoryDir.getAbsolutePath()));
            afterInstrumentationClasspath.append(new Path(this.getProject(), this.srcDir.getAbsolutePath()));
            afterInstrumentationClasspath.append(new Path(this.getProject(), this.buildDir.getAbsolutePath()));
            Path repositoryClasspath = (Path)baseClasspath.clone();
            repositoryClasspath.append(new Path(this.getProject(), this.instrumentDir.getAbsolutePath()));
            repositoryClasspath.append(new Path(this.getProject(), this.srcDir.getAbsolutePath()));
            repositoryClasspath.append(new Path(this.getProject(), this.repositoryDir.getAbsolutePath()));
            repositoryClasspath.append(new Path(this.getProject(), this.buildDir.getAbsolutePath()));
            Path iContractClasspath = (Path)baseClasspath.clone();
            iContractClasspath.append(new Path(this.getProject(), System.getProperty("java.home") + File.separator + ".." + File.separator + "lib" + File.separator + "tools.jar"));
            iContractClasspath.append(new Path(this.getProject(), this.srcDir.getAbsolutePath()));
            iContractClasspath.append(new Path(this.getProject(), this.repositoryDir.getAbsolutePath()));
            iContractClasspath.append(new Path(this.getProject(), this.instrumentDir.getAbsolutePath()));
            iContractClasspath.append(new Path(this.getProject(), this.buildDir.getAbsolutePath()));
            Java iContract = (Java)this.getProject().createTask("java");
            iContract.setTaskName(this.getTaskName());
            iContract.setFork(true);
            iContract.setClassname("com.reliablesystems.iContract.Tool");
            iContract.setClasspath(iContractClasspath);
            StringBuffer args = new StringBuffer();
            args.append(this.directiveString());
            args.append("-v").append(this.verbosity).append(" ");
            args.append("-b").append("\"").append(this.icCompiler);
            args.append(" -classpath ").append(beforeInstrumentationClasspath);
            args.append("\" ");
            args.append("-c").append("\"").append(this.icCompiler);
            args.append(" -classpath ").append(afterInstrumentationClasspath);
            args.append(" -d ").append(this.buildDir).append("\" ");
            args.append("-n").append("\"").append(this.icCompiler);
            args.append(" -classpath ").append(repositoryClasspath);
            args.append("\" ");
            args.append("-d").append(this.failThrowable).append(" ");
            args.append("-o").append(this.instrumentDir).append(File.separator);
            args.append("@p").append(File.separator).append("@f.@e ");
            args.append("-k").append(this.repositoryDir).append(File.separator);
            args.append("@p ");
            args.append(this.quiet ? "-q " : "");
            args.append(this.instrumentall ? "-a " : "");
            args.append("@").append(this.targets.getAbsolutePath());
            iContract.createArg().setLine(args.toString());
            if (this.updateIcontrol) {
                Properties iControlProps = new Properties();
                try {
                    iControlProps.load(new FileInputStream("icontrol.properties"));
                }
                catch (IOException e) {
                    this.log("File icontrol.properties not found. That's ok. Writing a default one.");
                }
                iControlProps.setProperty("sourceRoot", this.srcDir.getAbsolutePath());
                iControlProps.setProperty("classRoot", this.classDir.getAbsolutePath());
                iControlProps.setProperty("classpath", afterInstrumentationClasspath.toString());
                iControlProps.setProperty("controlFile", this.controlFile.getAbsolutePath());
                iControlProps.setProperty("targetsFile", this.targets.getAbsolutePath());
                try {
                    iControlProps.store(new FileOutputStream("icontrol.properties"), ICONTROL_PROPERTIES_HEADER);
                    this.log("Updated icontrol.properties");
                }
                catch (IOException e) {
                    this.log("Couldn't write icontrol.properties.");
                }
            }
            if ((result = iContract.executeJava()) != 0) {
                if (this.iContractMissing) {
                    this.log("iContract can't be found on your classpath. Your classpath is:");
                    this.log(this.classpath.toString());
                    this.log("If you don't have the iContract jar, go get it at http://www.reliable-systems.com/tools/");
                }
                throw new BuildException("iContract instrumentation failed. Code = " + result);
            }
        }
    }

    private void preconditions() throws BuildException {
        if (this.srcDir == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir \"" + this.srcDir.getPath() + "\" does not exist!", this.getLocation());
        }
        if (this.instrumentDir == null) {
            throw new BuildException("instrumentdir attribute must be set!", this.getLocation());
        }
        if (this.repositoryDir == null) {
            throw new BuildException("repositorydir attribute must be set!", this.getLocation());
        }
        if (this.updateIcontrol && this.classDir == null) {
            throw new BuildException("classdir attribute must be specified when updateicontrol=true!", this.getLocation());
        }
        if (this.updateIcontrol && this.controlFile == null) {
            throw new BuildException("controlfile attribute must be specified when updateicontrol=true!", this.getLocation());
        }
    }

    private void scan() throws BuildException {
        long now = new Date().getTime();
        DirectoryScanner ds = null;
        ds = this.getDirectoryScanner(this.srcDir);
        String[] files = ds.getIncludedFiles();
        FileOutputStream targetOutputStream = null;
        PrintStream targetPrinter = null;
        boolean writeTargets = false;
        try {
            if (this.targets == null) {
                this.targets = new File("targets");
                this.log("Warning: targets file not specified. generating file: " + this.targets.getName());
                writeTargets = true;
            } else if (!this.targets.exists()) {
                this.log("Specified targets file doesn't exist. generating file: " + this.targets.getName());
                writeTargets = true;
            }
            if (writeTargets) {
                this.log("You should consider using iControl to create a target file.");
                targetOutputStream = new FileOutputStream(this.targets);
                targetPrinter = new PrintStream(targetOutputStream);
            }
            int i = 0;
            while (i < files.length) {
                File srcFile = new File(this.srcDir, files[i]);
                if (files[i].endsWith(".java")) {
                    if (targetPrinter != null) {
                        targetPrinter.println(srcFile.getAbsolutePath());
                    }
                    File classFile = new File(this.buildDir, files[i].substring(0, files[i].indexOf(".java")) + ".class");
                    if (srcFile.lastModified() > now) {
                        this.log("Warning: file modified in the future: " + files[i], 1);
                    }
                    if (!classFile.exists() || srcFile.lastModified() > classFile.lastModified()) {
                        this.dirty = true;
                    }
                }
                ++i;
            }
            if (targetPrinter != null) {
                targetPrinter.flush();
                targetPrinter.close();
            }
        }
        catch (IOException e) {
            throw new BuildException("Could not create target file:" + e.getMessage());
        }
        long controlFileTime = -1L;
        try {
            if (this.controlFile != null && this.controlFile.exists() && this.buildDir.exists()) {
                controlFileTime = this.controlFile.lastModified();
                ds = this.getDirectoryScanner(this.buildDir);
                files = ds.getIncludedFiles();
                int i = 0;
                while (i < files.length) {
                    File srcFile = new File(this.srcDir, files[i]);
                    if (files[i].endsWith(".class") && controlFileTime > srcFile.lastModified()) {
                        if (!this.dirty) {
                            this.log("Control file " + this.controlFile.getAbsolutePath() + " has been updated. " + "Instrumenting all files...");
                        }
                        this.dirty = true;
                        this.instrumentall = true;
                    }
                    ++i;
                }
            }
        }
        catch (Throwable t) {
            throw new BuildException("Got an interesting exception:" + t.getMessage());
        }
    }

    private final String directiveString() {
        boolean useControlFile;
        StringBuffer sb = new StringBuffer();
        boolean comma = false;
        boolean bl = useControlFile = this.controlFile != null && this.controlFile.exists();
        if (useControlFile || this.pre || this.post || this.invariant) {
            sb.append("-m");
        }
        if (useControlFile) {
            sb.append("@").append(this.controlFile);
            comma = true;
        }
        if (this.pre) {
            if (comma) {
                sb.append(",");
            }
            sb.append("pre");
            comma = true;
        }
        if (this.post) {
            if (comma) {
                sb.append(",");
            }
            sb.append("post");
            comma = true;
        }
        if (this.invariant) {
            if (comma) {
                sb.append(",");
            }
            sb.append("inv");
        }
        sb.append(" ");
        return sb.toString();
    }

    private class ClasspathHelper
    extends DefaultCompilerAdapter {
        private final String compiler;

        public ClasspathHelper(String compiler) {
            this.compiler = compiler;
        }

        public void modify(Path path) {
            if ("jikes".equals(this.compiler)) {
                IContract.this.icCompiler = this.compiler;
                this.includeJavaRuntime = true;
                path.append(this.getCompileClasspath());
            }
        }

        public void setJavac(Javac javac) {
        }

        public boolean execute() {
            return true;
        }
    }

    private class IContractPresenceDetector
    implements BuildListener {
        private IContractPresenceDetector() {
        }

        public void buildFinished(BuildEvent event) {
        }

        public void buildStarted(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
            if ("java.lang.NoClassDefFoundError: com/reliablesystems/iContract/Tool".equals(event.getMessage())) {
                IContract.this.iContractMissing = true;
            }
        }

        public void targetFinished(BuildEvent event) {
        }

        public void targetStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }
    }
}

