/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.tasks;

import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ManifestReader
extends Task {
    private File jarfile;
    private String prefix;
    private boolean failOnManifestMissing = true;

    public void setJarfile(File jarfile) {
        this.jarfile = jarfile;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setFailOnManifestMissing(boolean failOnManifestMissing) {
        this.failOnManifestMissing = failOnManifestMissing;
    }

    public void execute() throws BuildException {
        if (this.jarfile == null) {
            throw new BuildException("The attribute jarfile must be set.");
        }
        if (!this.jarfile.exists()) {
            throw new BuildException("The file '" + this.jarfile.getAbsolutePath() + "' does not exists.");
        }
        try {
            JarFile jarfile = new JarFile(this.jarfile);
            Manifest manifest = jarfile.getManifest();
            if (manifest == null && this.failOnManifestMissing) {
                throw new BuildException("The file '" + this.jarfile.getAbsolutePath() + "' does not contain a manifest.");
            }
            if (manifest != null) {
                this.addManifestProperties(manifest.getMainAttributes(), "");
                for (String section : manifest.getEntries().keySet()) {
                    this.addManifestProperties(manifest.getAttributes(section), section);
                }
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void addManifestProperties(Attributes attributes, String section) {
        if (section.length() > 0) {
            section = section + '|';
        }
        for (Object key : attributes.keySet()) {
            Attributes.Name name = (Attributes.Name)key;
            String value = attributes.getValue(name);
            if (this.prefix == null) {
                this.getProject().setUserProperty(section + name.toString(), value);
                continue;
            }
            this.getProject().setUserProperty(section + this.prefix + '.' + name.toString(), value);
        }
    }
}

