/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration;

import ch.e2e.ant.gui.configuration.AntProjectFactory;
import ch.e2e.ant.gui.configuration.XmlStrings;
import ch.e2e.resource.Properties;
import ch.e2e.resource.Translator;
import ch.e2e.util.StringTools;
import java.awt.Color;
import java.util.Locale;
import java.util.Map;
import javax.swing.JFrame;
import org.apache.tools.ant.Project;
import org.w3c.dom.Element;

public class ConfigurationTools
implements XmlStrings {
    private static ConfigurationTools instance;
    private Translator translator = new Translator("ch.e2e.installer.properties.defaulttranslations", Locale.getDefault());
    private static String os;
    private Locale locale;
    private JFrame dialogParent;
    public static AntProjectFactory antProjectFactory;

    private ConfigurationTools() {
    }

    public static ConfigurationTools getInstance() {
        if (instance == null) {
            instance = new ConfigurationTools();
        }
        return instance;
    }

    public JFrame getDialogParent() {
        return this.dialogParent;
    }

    public void setDialogParent(JFrame dialogParent) {
        this.dialogParent = dialogParent;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.translator.setLocale(locale);
    }

    public Locale getLocale() {
        return this.locale == null ? Locale.getDefault() : this.locale;
    }

    public String getTranslation(String key) {
        return this.translator.getTranslation(key);
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public String getTranslatedString(String value) {
        return StringTools.replaceProperties((String)value, (Map)this.translator.getTranslations(), (String)"$[", (String)"]");
    }

    public static boolean checkIfUnless(String ifString, String unless, Project project) {
        boolean result = true;
        if (ifString != null) {
            String ifProperty = project.getProperty(ifString);
            boolean bl = result = ifProperty != null;
        }
        if (result && unless != null) {
            String unlessProperty = project.getProperty(unless);
            result = unlessProperty == null;
        }
        return result;
    }

    public static boolean checkIfUnless(String ifString, String unless, Properties properties) {
        return StringTools.checkIfUnless((String)ifString, (String)unless, (Properties)properties);
    }

    protected static String getAttribute(Element element, String name, String defaultValue) {
        if (element.hasAttribute(name)) {
            return element.getAttribute(name);
        }
        return defaultValue;
    }

    public static Color createColor(String colorString) {
        return ConfigurationTools.createColor(colorString, null);
    }

    public static Color createColor(String colorString, Color defaultColor) {
        try {
            return new Color(Integer.parseInt(colorString.substring(1), 16));
        }
        catch (Exception ex) {
            return defaultColor;
        }
    }

    public static boolean createBoolean(String booleanString) {
        boolean result = false;
        if (booleanString != null) {
            result = booleanString.equalsIgnoreCase("true") || booleanString.equalsIgnoreCase("yes");
        }
        return result;
    }

    protected static int createInteger(String integerString, int defaultInt) {
        try {
            return Integer.parseInt(integerString);
        }
        catch (Exception ex) {
            return defaultInt;
        }
    }

    public static boolean checkOs(String os) {
        os = os == null ? "" : os;
        String osToCheck = os.toLowerCase();
        return ConfigurationTools.os.indexOf(osToCheck) != -1;
    }

    static {
        os = System.getProperty("os.name").toLowerCase() + '-' + System.getProperty("os.arch");
        antProjectFactory = AntProjectFactory.newInstance();
    }
}

