/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.gui.uml;

import ch.e2e.builder.analyzer.gui.uml.ActivationBox;
import ch.e2e.builder.analyzer.gui.uml.PStateCall;
import ch.e2e.builder.analyzer.model.TransactionLogEntry;
import com.mxgraph.model.mxCell;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;

public class MessageToSelf
extends PStateCall {
    public static final double DX = 10.0;
    private int level = 1;

    public MessageToSelf(TransactionLogEntry entry) {
        super(entry);
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public void add(ActivationBox child) {
        super.add(child);
        if (child instanceof MessageToSelf) {
            this.updateLevel((MessageToSelf)child);
        }
    }

    public void updateLevel(MessageToSelf child) {
        int newLevel = child.level + 1;
        if (this.level < newLevel) {
            this.level = newLevel;
        }
        if (this.getParent() instanceof MessageToSelf) {
            ((MessageToSelf)this.getParent()).updateLevel(this);
        }
    }

    @Override
    public mxCell createCell(mxGraph graph, mxCell parentCell) {
        return null;
    }

    public void createEdge(mxGraph graph, mxCell parentCell, ActivationBox parent) {
        ArrayList<mxPoint> points = new ArrayList<mxPoint>(2);
        double y = (double)(this.getStartIndex() - parent.getStartIndex()) / (double)(parent.getEndIndex() - parent.getStartIndex());
        mxCell sourcePort = (mxCell)graph.insertVertex((Object)parentCell, null, null, 1.0, y, 0.0, 0.0);
        sourcePort.getGeometry().setRelative(true);
        double x = 10.0 * (double)this.getLevel();
        points.add(new mxPoint(parentCell.getGeometry().getX() + parentCell.getGeometry().getWidth() + x, y * parentCell.getGeometry().getHeight()));
        y = (double)(this.getEndIndex() - parent.getStartIndex()) / (double)(parent.getEndIndex() - parent.getStartIndex());
        mxCell targetPort = (mxCell)graph.insertVertex((Object)parentCell, null, null, 1.0, y, 0.0, 0.0);
        targetPort.getGeometry().setRelative(true);
        points.add(new mxPoint(parentCell.getGeometry().getX() + parentCell.getGeometry().getWidth() + x, y * parentCell.getGeometry().getHeight()));
        String style = this.getReturnMessage().hasError() ? "transition;strokeColor=red;fontColor=red" : "transition";
        mxCell edge = (mxCell)graph.insertEdge((Object)parentCell, null, (Object)this, (Object)sourcePort, (Object)targetPort, style);
        edge.getGeometry().setX(1.0);
        edge.getGeometry().setY(1.0);
        edge.getGeometry().setOffset(new mxPoint(x, 0.0));
        edge.getGeometry().setPoints(points);
        for (ActivationBox child : this.getChildren()) {
            if (!(child instanceof MessageToSelf)) continue;
            ((MessageToSelf)child).createEdge(graph, parentCell, parent);
        }
    }

    @Override
    public String toString() {
        return this.getReturnMessage().toString() + " (" + this.getDuration() + "ms)";
    }
}

