/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.gui.uml;

import ch.e2e.builder.analyzer.gui.uml.ActivationBox;
import ch.e2e.builder.analyzer.gui.uml.ObjectWithToolTip;
import ch.e2e.builder.analyzer.model.TransactionLogEntry;
import ch.e2e.util.StringTools;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxICell;
import com.mxgraph.view.mxGraph;
import java.util.Arrays;

public class CustomBox
extends ActivationBox
implements ObjectWithToolTip {
    private String label;
    private String tooltip;

    public CustomBox(TransactionLogEntry entry) {
        super(entry);
        this.label = entry.getComponentName();
        this.setToolTipText("Param 1: " + entry.getParam_1(), "Param 2: " + entry.getParam_2());
    }

    @Override
    public String getLifelineKey() {
        ActivationBox parent = this.getParent();
        return parent == null ? "actor" : parent.getLifelineKey();
    }

    @Override
    public String getLifelineName() {
        ActivationBox parent = this.getParent();
        return parent == null ? "actor" : parent.getLifelineName();
    }

    @Override
    public String getToolTipText() {
        return this.tooltip;
    }

    @Override
    public mxCell createCell(mxGraph graph, mxCell parentCell) {
        mxCell cell = (mxCell)graph.insertVertex((Object)parentCell, this.getCellKey(), (Object)this, 0.0, 0.0, 0.0, 0.0, "customBox");
        graph.updateCellSize((Object)cell);
        double x = parentCell.getChildAt(0).getGeometry().getCenterX() + 50.0;
        double y = 30.0 * (double)(this.getStartIndex() + 3) - 0.5 * cell.getGeometry().getHeight();
        if (this.getParent() == null) {
            graph.translateCell((Object)cell, x, -0.5 * cell.getGeometry().getHeight());
        } else {
            graph.translateCell((Object)cell, x, y);
        }
        return cell;
    }

    @Override
    public boolean createEdges(mxGraph graph) {
        boolean created = false;
        ActivationBox caller = this.getCaller();
        if (caller != this) {
            mxCell sourceCell = this.findCell(graph, caller.getCellKey());
            if (sourceCell != null) {
                created = true;
                mxCell cell = this.findCell(graph, this.getCellKey());
                double x = 1.0;
                double y = (cell.getGeometry().getCenterY() - sourceCell.getGeometry().getY()) / sourceCell.getGeometry().getHeight();
                mxCell sourcePort = (mxCell)graph.insertVertex((Object)sourceCell, null, null, x, y, 0.0, 0.0);
                sourcePort.getGeometry().setRelative(true);
                mxCell targetPort = (mxCell)graph.insertVertex((Object)cell, null, null, 0.0, 0.5, 0.0, 0.0);
                targetPort.getGeometry().setRelative(true);
                graph.insertEdge(null, null, null, (Object)sourcePort, (Object)targetPort, "customEdge");
            }
        } else if (this.getParent() == null) {
            mxCell cell = this.findCell(graph, this.getCellKey());
            mxICell sourceCell = cell.getParent();
            mxICell objectCell = sourceCell.getChildAt(0);
            double x = objectCell.getGeometry().getCenterX() / sourceCell.getGeometry().getWidth();
            double y = (cell.getGeometry().getY() + 0.5 * cell.getGeometry().getHeight()) / sourceCell.getGeometry().getHeight();
            mxCell sourcePort = (mxCell)graph.insertVertex((Object)sourceCell, null, null, x, y, 0.0, 0.0);
            sourcePort.getGeometry().setRelative(true);
            mxCell targetPort = (mxCell)graph.insertVertex((Object)cell, null, null, 0.0, 0.5, 0.0, 0.0);
            targetPort.getGeometry().setRelative(true);
            graph.insertEdge(null, null, null, (Object)sourcePort, (Object)targetPort, "customEdge");
        }
        return created;
    }

    @Override
    public void createCustomBoxes(mxGraph graph, mxCell parentCell) {
    }

    @Override
    public String toString() {
        return this.label;
    }

    private void setToolTipText(String ... lines) {
        this.tooltip = "<html>" + StringTools.join(Arrays.asList(lines), (String)"<br>") + "</html>";
    }
}

