/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.project;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.module.ModuleFactory;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.base.project.ProjectConstants;
import ch.e2e.builder.base.project.ProjectPool;
import ch.e2e.builder.base.project.event.ProjectEditEvent;
import ch.e2e.builder.base.project.gui.ProjectDialog;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import java.awt.Frame;
import java.awt.Window;
import java.util.EventObject;
import java.util.HashMap;

public class EditProjectExecuter
implements EventExecuter,
ProjectConstants {
    private HashMap<Window, ProjectDialog> dialogs = new HashMap();
    private ProjectPool pool;
    private ModuleFactory moduleFactory;

    public EditProjectExecuter(ProjectPool pool, ModuleFactory moduleFactory) {
        this.pool = pool;
        this.moduleFactory = moduleFactory;
    }

    public void execute(EventObject event) {
        try {
            this.pool.fireDoBeforeChanging();
            Frame parentFrame = E2EBuilder.getInstance().getParentFrame();
            ProjectDialog projectDialog = this.dialogs.get(parentFrame);
            if (projectDialog == null) {
                projectDialog = new ProjectDialog(this.moduleFactory.getModules().iterator(), E2EBuilderTranslator.getTranslation((String)"project.edit.title", (String)"project.edit.title"), E2EBuilderTranslator.getTranslation((String)"project.edit.internaltitle", (String)"project.edit.internaltitle"), E2EBuilderTranslator.getTranslation((String)"project.edit.subtitle", (String)"project.edit.subtitle"));
                this.dialogs.put(parentFrame, projectDialog);
            }
            ProjectEditEvent projectEvent = (ProjectEditEvent)((Object)event);
            E2EBuilderModule module = projectEvent.getModule();
            E2EBuilderProject actualProject = this.pool.getActualProject();
            if (projectDialog.editProject(actualProject, module)) {
                this.pool.settingsChanged();
            }
        }
        catch (EventExecutionVetoException eventExecutionVetoException) {
            // empty catch block
        }
    }
}

