/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.plugin.gui;

import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class MenuLabel {
    private String label;
    private int mnemonic;
    private KeyStroke keyStroke;
    private Icon icon;
    private String key;

    public MenuLabel(String key) {
        this(E2EBuilderTranslator.getTranslation((String)key, (String)key), null, key);
    }

    public MenuLabel(String moduleName, String key) {
        this(moduleName, key, null);
    }

    public MenuLabel(String key, Icon icon) {
        this(E2EBuilderTranslator.getTranslation((String)key, (String)key), icon, key);
    }

    public MenuLabel(String moduleName, String key, Icon icon) {
        this(E2EBuilderTranslator.getModuleTranslation((String)moduleName, (String)key, (String)key), icon, key);
    }

    private MenuLabel(String translation, Icon icon, String key) {
        this.key = "ch.e2e.builder." + key;
        this.icon = icon;
        StringTokenizer tokenizer = new StringTokenizer(translation, ";", true);
        this.label = translation;
        this.keyStroke = null;
        this.mnemonic = -1;
        if (tokenizer.hasMoreTokens()) {
            this.label = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                tokenizer.nextToken();
                this.mnemonic = this.getMnemonic(tokenizer);
                if (tokenizer.hasMoreTokens()) {
                    this.keyStroke = KeyStroke.getKeyStroke(tokenizer.nextToken());
                }
            }
        }
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public String getLabel() {
        return this.label;
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getKey() {
        return this.key;
    }

    private int getMnemonic(StringTokenizer tokenizer) {
        String s;
        int mnemonic = -1;
        if (tokenizer.hasMoreTokens() && !(s = tokenizer.nextToken()).equals(";")) {
            mnemonic = s.charAt(0);
            if (tokenizer.hasMoreTokens()) {
                tokenizer.nextToken();
            }
        }
        return mnemonic;
    }
}

