/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.renderer;

import ch.e2e.swing.renderer.CheckBoxTreeCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;

public class CheckBoxTreeCellComponent
extends AbstractCellEditor
implements TreeCellEditor,
CheckBoxTreeCellRenderer {
    private final CheckBoxPanel component;
    private final TreeCellRenderer renderer;

    public CheckBoxTreeCellComponent(TreeCellRenderer renderer, SelectionDelegator selectionDelegator) {
        this.renderer = renderer;
        this.component = new CheckBoxPanel(selectionDelegator);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.component.update(value, this.renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus));
        return this.component;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        return this.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
    }

    @Override
    public boolean isInCheckBox(int x, int y) {
        return this.component.isInCheckBox(x, y);
    }

    @Override
    public Object getCellEditorValue() {
        return this.component.getValue();
    }

    public static interface SelectionDelegator {
        public void setSelected(Object var1, boolean var2);

        public boolean isSelected(Object var1);
    }

    private static class CheckBoxPanel
    extends JPanel {
        private final JCheckBox checkBox;
        private final SelectionDelegator selectionDelegator;
        private Object value;

        public CheckBoxPanel(SelectionDelegator selectionDelegator) {
            super(new BorderLayout());
            this.selectionDelegator = selectionDelegator;
            this.checkBox = new JCheckBox();
            this.checkBox.setOpaque(false);
            this.checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CheckBoxPanel.this.selectionDelegator.setSelected(CheckBoxPanel.this.value, CheckBoxPanel.this.checkBox.isSelected());
                }
            });
            this.setOpaque(false);
            this.add((Component)this.checkBox, "Before");
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isInCheckBox(int x, int y) {
            return this.checkBox.contains(x, y);
        }

        public void update(Object value, Component rendererComponent) {
            this.value = value;
            this.checkBox.setSelected(this.selectionDelegator.isSelected(value));
            this.add(rendererComponent, "Center");
        }
    }
}

