/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.model;

import ch.e2e.io.FileUtilities;
import ch.e2e.swing.filechooser.FileChooserConstants;
import ch.e2e.swing.model.DirectoryTreeModelExtension;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class Directory {
    private static Directory systemRoot = new Directory();
    private Directory parent;
    private File dir;
    private ArrayList subdirs;
    private ArrayList existingDirs;
    private long lastModified = -1L;
    private int type = -1;

    private Directory(File dir) {
        this.dir = dir;
        this.loadSubdirs();
    }

    private Directory() {
        File[] subdirArray = File.listRoots();
        this.fillLists(subdirArray);
    }

    private Directory(File dir, Directory parent) {
        this.dir = dir;
        this.parent = parent;
    }

    public static Directory getRoot() {
        return systemRoot;
    }

    public static Directory getAsRoot(File dir) {
        if (dir == null) {
            return systemRoot;
        }
        return new Directory(dir);
    }

    public static Directory getDirectory(File dir) {
        Directory result;
        if (dir == null) {
            result = systemRoot;
        } else {
            Directory[] path = systemRoot.getPath(dir);
            result = path[path.length - 1];
        }
        return result;
    }

    public int getType(DirectoryTreeModelExtension treeModelExtension) {
        return this.type == -1 ? this.setType(treeModelExtension) : this.type;
    }

    private int setType(DirectoryTreeModelExtension treeModelExtension) {
        if (this.dir == null) {
            this.type = 0;
        } else {
            int n = this.type = treeModelExtension == null ? -1 : treeModelExtension.getType(this.dir);
            if (this.type == -1) {
                this.type = this.isRoot() && FileChooserConstants.WINDOWS ? 1 : 2;
            }
        }
        return this.type;
    }

    public Directory getParent() {
        return this.parent;
    }

    public File getDir() {
        return this.dir;
    }

    public Directory getSubdir(File subdir) {
        Directory directory = null;
        int length = this.getSubdirs().size();
        for (int i = 0; i < length; ++i) {
            if (!((Directory)this.subdirs.get(i)).getDir().equals(subdir)) continue;
            directory = (Directory)this.subdirs.get(i);
            break;
        }
        return directory;
    }

    public Directory[] getPath(File directory) {
        Directory[] path = null;
        File[] paths = FileUtilities.getPathToRoot((File)directory);
        int index = -1;
        if (this.dir == null) {
            index = 0;
        } else {
            for (int i = 0; i < paths.length; ++i) {
                if (!paths[i].equals(this.dir)) continue;
                index = i + 1;
                break;
            }
        }
        if (index != -1) {
            File[] dummy = paths;
            paths = new File[dummy.length - index];
            System.arraycopy(dummy, index, paths, 0, paths.length);
            ArrayList pathDirs = this.getPath(paths, true);
            path = new Directory[pathDirs.size()];
            pathDirs.toArray(path);
        }
        return path;
    }

    public Directory[] getPathToRoot() {
        ArrayList<Directory> dirs = new ArrayList<Directory>();
        for (Directory directory = this; directory != null; directory = directory.getParent()) {
            dirs.add(0, directory);
        }
        Directory[] path = new Directory[dirs.size()];
        dirs.toArray(path);
        return path;
    }

    public Directory[] getPath(Directory directory) {
        ArrayList<Directory> dirs = new ArrayList<Directory>();
        while (directory.dir != null && !directory.dir.equals(this.dir)) {
            dirs.add(0, directory);
            directory = directory.getParent();
        }
        Directory[] path = null;
        if (directory.dir == null && this.dir == null || directory.dir != null && this.dir != null && directory.dir.equals(this.dir)) {
            path = new Directory[dirs.size()];
            dirs.toArray(path);
        }
        return path;
    }

    public ArrayList getPath(File[] path) {
        return this.getPath(path, false);
    }

    public ArrayList getPath(File[] path, boolean create) {
        ArrayList<Directory> pathList = new ArrayList<Directory>();
        if (this.dir == null) {
            pathList.add(this);
        }
        int length = this.getSubdirs().size();
        boolean pathNotFound = true;
        for (int i = 0; i < length && pathNotFound; ++i) {
            Directory directory = (Directory)this.subdirs.get(i);
            if (!directory.dir.equals(path[0])) continue;
            pathList.add(directory);
            if (path.length > 1) {
                File[] subPath = new File[path.length - 1];
                System.arraycopy(path, 1, subPath, 0, subPath.length);
                pathList.addAll(directory.getPath(subPath, create));
            }
            pathNotFound = false;
        }
        if (pathNotFound && create) {
            Directory newDir = new Directory(path[0], this);
            pathList.add(newDir);
            this.addSubdir(newDir);
            if (path.length > 1) {
                File[] subPath = new File[path.length - 1];
                System.arraycopy(path, 1, subPath, 0, subPath.length);
                pathList.addAll(newDir.getPath(subPath, create));
            }
        }
        return pathList;
    }

    public ArrayList getSubdirs() {
        if (this.subdirs == null || this.dir != null && this.lastModified < this.dir.lastModified()) {
            this.loadSubdirs();
        }
        return this.subdirs;
    }

    public ArrayList getExistingDirs() {
        if (this.subdirs == null) {
            this.loadSubdirs();
        }
        return this.existingDirs;
    }

    public Directory get(int index) {
        return (Directory)this.getSubdirs().get(index);
    }

    public Directory getExisting(int index) {
        return (Directory)this.getExistingDirs().get(index);
    }

    public int indexOf(Directory directory) {
        return this.getSubdirs().indexOf(directory);
    }

    public int indexOfExisting(Directory directory) {
        return this.getExistingDirs().indexOf(directory);
    }

    public boolean isRoot() {
        return this.dir == null ? true : this.dir.getName().length() == 0;
    }

    public int size() {
        return this.subdirs == null ? 1 : this.subdirs.size();
    }

    public int sizeExisting() {
        return this.existingDirs == null ? 1 : this.existingDirs.size();
    }

    public String toString() {
        if (this.dir == null) {
            return "My Filesystem";
        }
        return this.dir.getName().length() > 0 ? this.dir.getName() : this.dir.getAbsolutePath();
    }

    public void expand() {
        if (this.dir != null && (this.subdirs == null || this.lastModified < this.dir.lastModified())) {
            this.loadSubdirs();
        }
    }

    public long lastModified() {
        return this.dir == null ? 0L : this.dir.lastModified();
    }

    public void reset() {
        ArrayList<Directory> dirsToRemove = new ArrayList<Directory>();
        if (this.subdirs != null) {
            int length = this.subdirs.size();
            for (int i = 0; i < length; ++i) {
                Directory directory = (Directory)this.subdirs.get(i);
                directory.reset();
                if (this.existingDirs.contains(directory)) continue;
                dirsToRemove.add(directory);
            }
            this.subdirs.removeAll(dirsToRemove);
        }
    }

    private void addSubdir(Directory subdir) {
        Directory dir;
        int i;
        int length = this.subdirs.size();
        String filename = subdir.getDir().getName();
        for (i = 0; i < length; ++i) {
            dir = (Directory)this.subdirs.get(i);
            if (dir.getDir().getName().compareToIgnoreCase(filename) <= 0) continue;
            this.subdirs.add(i, subdir);
            break;
        }
        if (subdir.getDir().exists()) {
            for (i = 0; i < length; ++i) {
                dir = (Directory)this.subdirs.get(i);
                if (dir.getDir().getName().compareToIgnoreCase(filename) <= 0) continue;
                this.existingDirs.add(i, subdir);
                break;
            }
        }
    }

    private void loadSubdirs() {
        File[] subdirArray = FileUtilities.getAllDirectories((File)this.dir);
        this.fillLists(subdirArray);
        this.lastModified = this.dir.lastModified();
    }

    private void fillLists(File[] subdirArray) {
        if (this.subdirs == null) {
            this.subdirs = new ArrayList();
            this.existingDirs = new ArrayList();
        } else {
            this.subdirs.clear();
            this.existingDirs.clear();
        }
        if (subdirArray != null && subdirArray.length > 0) {
            Arrays.sort(subdirArray);
            for (int i = 0; i < subdirArray.length; ++i) {
                Directory directory = new Directory(subdirArray[i], this);
                this.subdirs.add(directory);
                this.existingDirs.add(directory);
            }
        }
    }
}

