/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.filechooser;

import ch.e2e.swing.MouseOverButton;
import ch.e2e.swing.event.DirectorySelectedEvent;
import ch.e2e.swing.event.DirectorySelectedEventMulticaster;
import ch.e2e.swing.event.DirectorySelectedListener;
import ch.e2e.swing.filechooser.FileChooserIcons;
import ch.e2e.swing.model.Directory;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JPanel;

public abstract class DirectoryButtonPanel
extends JPanel
implements FileChooserIcons,
DirectorySelectedListener {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected Directory selectedDirectory;
    protected JPanel buttonPanel;
    private int alignment;
    private DirectorySelectedListener directorySelectedListener;

    public DirectoryButtonPanel(int alignment) {
        this.alignment = alignment;
        this.createGui();
    }

    @Override
    public void setBackground(Color background) {
        if (this.buttonPanel != null) {
            this.buttonPanel.setBackground(background);
        }
        super.setBackground(background);
    }

    public void setSelectedDirectory(Directory selectedDirectory) {
        this.selectedDirectory = selectedDirectory;
        this.selectDirectory(selectedDirectory);
    }

    public MouseOverButton addButton(Icon icon, final File directory) {
        if (directory != null) {
            return this.addButton(icon, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DirectoryButtonPanel.this.fireDirectorySelected(directory);
                }
            });
        }
        return null;
    }

    public MouseOverButton addButton(Icon icon, final File directory, boolean opaque) {
        if (directory != null) {
            return this.addButton(icon, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DirectoryButtonPanel.this.fireDirectorySelected(directory);
                }
            }, opaque);
        }
        return null;
    }

    public MouseOverButton addButton(Icon icon, ActionListener action, boolean opaque) {
        MouseOverButton button = this.addButton(icon, action);
        button.setOpaque(opaque);
        return button;
    }

    public MouseOverButton addButton(Icon icon, ActionListener action) {
        GridLayout layout = (GridLayout)this.buttonPanel.getLayout();
        if (this.alignment == 0) {
            layout.setColumns(this.buttonPanel.getComponentCount() + 1);
        } else {
            layout.setRows(this.buttonPanel.getComponentCount() + 1);
        }
        MouseOverButton directoryButton = new MouseOverButton(icon);
        directoryButton.addActionListener(action);
        this.buttonPanel.add(directoryButton);
        return directoryButton;
    }

    public void addDirectorySelectedListener(DirectorySelectedListener listener) {
        this.directorySelectedListener = DirectorySelectedEventMulticaster.addListener(this.directorySelectedListener, listener);
    }

    public void removeDirectorySelectedListener(DirectorySelectedListener listener) {
        this.directorySelectedListener = DirectorySelectedEventMulticaster.removeListener(this.directorySelectedListener, listener);
    }

    @Override
    public void directorySelected(DirectorySelectedEvent event) {
        this.setSelectedDirectory(event.getDirectory());
    }

    protected abstract void selectDirectory(Directory var1);

    protected void fireDirectorySelected(File selectedDirectory) {
        this.fireDirectorySelected(Directory.getDirectory(selectedDirectory));
    }

    protected void fireDirectorySelected(Directory selectedDirectory) {
        this.setSelectedDirectory(selectedDirectory);
        if (this.directorySelectedListener != null) {
            this.directorySelectedListener.directorySelected(new DirectorySelectedEvent(this, selectedDirectory));
        }
    }

    private void createGui() {
        this.setLayout(new FlowLayout(1, 2, 2));
        this.buttonPanel = new JPanel(new GridLayout(1, 1));
        this.add(this.buttonPanel);
    }
}

