/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.VerticalLabelUI;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class VerticalLabel
extends JComponent {
    public static final int UP = 270;
    public static final int DOWN = 90;
    private static final String uiClassID = "VerticalLabelUI";
    private String text;
    private int direction;

    public VerticalLabel(String text) {
        this(text, 270);
    }

    public VerticalLabel(String text, int direction) {
        this.setUI(VerticalLabelUI.createUI(this));
        this.setText(text);
        this.direction = direction;
        Font font = UIManager.getDefaults().getFont("Label.font");
        this.setFont(font);
    }

    public void setText(String text) {
        if (this.text == null || !this.text.equals(text)) {
            this.firePropertyChange("text", this.text, text);
            this.text = text;
        }
    }

    public String getText() {
        return this.text;
    }

    public AffineTransform getAffineTransform() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int width = fm.stringWidth(this.text);
        int height = fm.getHeight();
        AffineTransform at = new AffineTransform();
        at.rotate(Math.toRadians(this.direction));
        if (this.direction == 270) {
            at.translate(-width, height - fm.getDescent());
        } else {
            at.translate(0.0, -fm.getDescent());
        }
        return at;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }
}

