/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.gui.InputField;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldEventMulticaster;
import ch.e2e.gui.event.InputFieldListener;
import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class InputTextField
extends JTextField
implements InputField,
DocumentListener {
    private InputFieldListener listener;
    private Color background;
    private Color disabledBackground = Color.lightGray;
    private boolean ignoreSetBackground = false;

    public InputTextField() {
        this.getDocument().addDocumentListener(this);
        this.background = this.getBackground();
    }

    public InputTextField(int columns) {
        super(columns);
        this.getDocument().addDocumentListener(this);
        this.background = this.getBackground();
    }

    public InputTextField(String text) {
        super(text);
        this.getDocument().addDocumentListener(this);
        this.background = this.getBackground();
    }

    @Override
    public void setBackground(Color background) {
        if (!this.ignoreSetBackground) {
            this.background = background;
        }
        super.setBackground(background);
    }

    public void setDisabledBackground(Color disabledBackground) {
        this.disabledBackground = disabledBackground;
    }

    @Override
    public void setDocument(Document document) {
        if (this.getDocument() != null) {
            this.getDocument().removeDocumentListener(this);
        }
        document.addDocumentListener(this);
        super.setDocument(document);
    }

    @Override
    public Object getContent() {
        return this.getText();
    }

    @Override
    public void setContent(Object content) {
        this.setText(content == null ? "" : content.toString());
    }

    @Override
    public void addInputFieldListener(InputFieldListener listener) {
        this.listener = InputFieldEventMulticaster.addListener(this.listener, listener);
    }

    @Override
    public void removeInputFieldListener(InputFieldListener listener) {
        this.listener = InputFieldEventMulticaster.removeListener(this.listener, listener);
    }

    public void fireInputField() {
        if (this.listener != null) {
            this.listener.inputFieldChanged(new InputFieldEvent(this));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireInputField();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireInputField();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.ignoreSetBackground = true;
        super.setEnabled(enabled);
        super.setBackground(enabled ? this.background : this.disabledBackground);
        this.ignoreSetBackground = false;
    }
}

