/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.GenericInputNumberField;
import ch.e2e.swing.document.BigDecimalFieldDocument;
import java.math.BigDecimal;

public class InputBigDecimalField
extends GenericInputNumberField<BigDecimal> {
    public InputBigDecimalField(BigDecimal min, BigDecimal max, BigDecimal increment, BigDecimal startValue) {
        super(new BigDecimalFieldDocument(min, max), min, max, increment);
        this.setContent(startValue);
    }

    public InputBigDecimalField(BigDecimal min, BigDecimal max, BigDecimal increment) {
        this(min, max, increment, null);
    }

    public InputBigDecimalField(BigDecimal min, BigDecimal max) {
        this(min, max, BigDecimal.ZERO);
    }

    public InputBigDecimalField() {
        this(null, null, BigDecimal.ZERO);
    }

    public InputBigDecimalField(String min, String max, String increment, String startValue) {
        this(new BigDecimal(min), new BigDecimal(max), new BigDecimal(increment), new BigDecimal(startValue));
    }

    public InputBigDecimalField(String min, String max, String increment) {
        this(new BigDecimal(min), new BigDecimal(max), new BigDecimal(increment));
    }

    public InputBigDecimalField(String min, String max) {
        this(new BigDecimal(min), new BigDecimal(max));
    }

    public InputBigDecimalField(double min, double max, double increment, double startValue) {
        this(BigDecimal.valueOf(min), BigDecimal.valueOf(max), BigDecimal.valueOf(increment), BigDecimal.valueOf(startValue));
    }

    public InputBigDecimalField(double min, double max, double increment) {
        this(BigDecimal.valueOf(min), BigDecimal.valueOf(max), BigDecimal.valueOf(increment));
    }

    public InputBigDecimalField(double min, double max) {
        this(BigDecimal.valueOf(min), BigDecimal.valueOf(max));
    }

    @Override
    protected boolean isNaN(BigDecimal value) {
        return value == null;
    }

    @Override
    protected BigDecimal newValue(BigDecimal value) {
        return new BigDecimal(value.unscaledValue(), value.scale());
    }

    @Override
    protected BigDecimal increment(BigDecimal value) {
        return value.add((BigDecimal)this.increment);
    }

    @Override
    protected BigDecimal decrement(BigDecimal value) {
        return value.subtract((BigDecimal)this.increment);
    }
}

