/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.awt;

import ch.e2e.awt.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class MessageBox
extends Dialog
implements ActionListener {
    public MessageBox(String message, String title, Frame owner) {
        super(owner, title, true);
        this.addWindowListener();
        this.createGui(message);
    }

    public MessageBox(String message, String title) {
        super(new Frame(), title, true);
        this.addWindowListener();
        this.createGui(message);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.close();
    }

    public void centerOnScreen() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.centerDialog(new Rectangle(0, 0, screenSize.width, screenSize.height));
    }

    public void centerDialog(Rectangle bounds) {
        int yPos;
        this.pack();
        Dimension dialogSize = this.getPreferredSize();
        int xPos = bounds.x + (bounds.width - dialogSize.width) / 2;
        if (xPos < 0) {
            xPos = 0;
        }
        if ((yPos = bounds.y + (bounds.height - dialogSize.height) / 2) < 0) {
            yPos = 0;
        }
        this.setBounds(xPos, yPos, dialogSize.width, dialogSize.height);
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void addWindowListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                MessageBox.this.close();
            }
        });
    }

    private void createGui(String message) {
        this.setLayout(new BorderLayout());
        MultiLineLabel l = new MultiLineLabel(message);
        this.add((Component)l, "Center");
        Button b = new Button("Ok");
        b.addActionListener(this);
        Panel p = new Panel(new FlowLayout(1));
        p.add(b);
        this.add((Component)p, "South");
        this.pack();
    }
}

